/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.sap.cds.SessionContext;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Upsert;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class PathExpressionResolver {
    private final CdsModel cdsModel;
    private final CqnStructuredTypeRef ref;
    private final SessionContext sessionContext;

    private PathExpressionResolver(CdsModel cdsModel, CqnStructuredTypeRef ref, SessionContext sessionContext) {
        this.cdsModel = cdsModel;
        this.ref = ref;
        this.sessionContext = sessionContext;
    }

    public static <S extends CqnXsert> S resolvePath(CdsModel cdsModel, S statement, SessionContext sessionContext) {
        PathExpressionResolver per = new PathExpressionResolver(cdsModel, statement.ref(), sessionContext);
        LinkedList<Entry> path = per.unfoldPathExpression();
        if (!PathExpressionResolver.isPathExpression(path)) {
            if (path.getFirst().filter != null) {
                throw new UnsupportedOperationException("Infix filters are not supported in Insert/Upsert statements: " + statement);
            }
            return statement;
        }
        List<Map<String, Object>> entries = PathExpressionResolver.addValues(statement.entries(), per.getTargetFkValues(PathExpressionResolver.parentEntry(path)));
        CdsEntity target = PathExpressionResolver.targetEntity(path);
        if (statement.isInsert()) {
            return (S)Insert.into((CdsEntity)target).entries(entries);
        }
        if (statement.isUpsert()) {
            return (S)Upsert.into((CdsEntity)target).entries(entries);
        }
        throw new IllegalStateException();
    }

    public static CqnUpdate resolvePath(CdsModel cdsModel, CqnUpdate update) {
        CqnStructuredTypeRef ref = update.ref();
        CdsEntity target = CdsModelUtils.entity(cdsModel, ref);
        Update resolved = Update.entity((CdsEntity)target).entries((Iterable)update.entries());
        PathExpressionResolver.addWhere(ref, target, update.where(), arg_0 -> ((Update)resolved).where(arg_0));
        return resolved;
    }

    public static CqnSelect resolvePath(CdsModel cdsModel, CqnSelect select) {
        if (select.from().isRef()) {
            CqnStructuredTypeRef ref = select.ref();
            CdsEntity target = CdsModelUtils.entity(cdsModel, ref);
            Select resolved = Select.from((CdsEntity)target).columns(select.items()).orderBy(select.orderBy());
            PathExpressionResolver.addWhere(ref, target, select.where(), arg_0 -> ((Select)resolved).where(arg_0));
            return resolved;
        }
        return select;
    }

    public static CqnDelete resolvePath(CdsModel cdsModel, CqnDelete delete) {
        CqnStructuredTypeRef ref = delete.ref();
        CdsEntity target = CdsModelUtils.entity(cdsModel, ref);
        Delete resolved = Delete.from((CdsEntity)target);
        PathExpressionResolver.addWhere(ref, target, delete.where(), arg_0 -> ((Delete)resolved).where(arg_0));
        return resolved;
    }

    private static void addWhere(CqnStructuredTypeRef ref, CdsEntity target, Optional<CqnPredicate> where, Consumer<CqnPredicate> filterable) {
        Optional<CqnPredicate> refFilter = ref.segments().size() == 1 ? ref.rootSegment().filter() : Optional.of(PathExpressionResolver.resolveUsingSubquery((CdsStructuredType)target, ref));
        Conjunction.and(refFilter, where).ifPresent(filterable::accept);
    }

    private static CqnPredicate resolveUsingSubquery(CdsStructuredType target, CqnStructuredTypeRef ref) {
        return new ExistsSubquery((CqnSelect)Select.from((CqnStructuredTypeRef)ref).where(CqnStatementUtils.linkKeysToOuterQuery(target)));
    }

    private Map<String, Object> getTargetFkValues(Entry parentEntry) {
        if (null == parentEntry.filter) {
            throw new UnsupportedOperationException("Statements with path expression are only supported with filter by keys. Structured type reference: " + this.ref);
        }
        String association = this.ref.lastSegment();
        CdsEntity entity = parentEntry.entity;
        Map<String, Object> parentFilterValues = new OnConditionAnalyzer(association, parentEntry.filter, true).getParentPkValues();
        return this.calculateFkValues(entity, association, parentFilterValues);
    }

    private static Entry parentEntry(LinkedList<Entry> path) {
        Iterator<Entry> iterator = path.descendingIterator();
        iterator.next();
        return iterator.next();
    }

    private static CdsEntity targetEntity(LinkedList<Entry> path) {
        Iterator<Entry> iterator = path.descendingIterator();
        return iterator.next().entity;
    }

    private static List<Map<String, Object>> addValues(List<Map<String, Object>> entries, Map<String, Object> values) {
        List<Map<String, Object>> copy = entries.stream().map(HashMap::new).collect(Collectors.toList());
        copy.forEach(e -> e.putAll(values));
        return copy;
    }

    private LinkedList<Entry> unfoldPathExpression() {
        LinkedList<Entry> path = new LinkedList<Entry>();
        path.add(new Entry(this.cdsModel.getEntity(this.ref.firstSegment()), ((CqnReference.Segment)this.ref.segments().get(0)).filter()));
        if (this.ref.segments().size() > 1) {
            this.ref.segments().stream().skip(1L).forEach(s -> {
                CdsEntity entity = ((Entry)path.getLast()).entity;
                path.add(new Entry((CdsEntity)entity.getTargetOf(s.id()), s.filter()));
            });
        }
        return path;
    }

    private Map<String, Object> calculateFkValues(CdsEntity entity, String associationName, Map<String, Object> filterValues) {
        CdsElement association = entity.getAssociation(associationName);
        if (!CdsModelUtils.isReverseAssociation(association)) {
            throw new UnsupportedOperationException("Path expressions in insert on forward mapped associations are not supported");
        }
        return new OnConditionAnalyzer(association, true, this.sessionContext).getFkValues(filterValues);
    }

    private static boolean isPathExpression(List<Entry> path) {
        return path.size() > 1;
    }

    private static class Entry {
        CdsEntity entity;
        CqnPredicate filter;

        public Entry(CdsEntity entity, Optional<CqnPredicate> filter) {
            this.entity = entity;
            this.filter = filter.orElse(null);
        }
    }
}

