/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.sap.cds.Result;
import com.sap.cds.impl.ResultImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsElementNotFoundException;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProjectionResolver<T extends CqnStatement> {
    private static final String UNKNOWN = "$unknown$";
    private static final BiPredicate DEFAULT_STOP_CONDITION = (prev, stmnt) -> prev == stmnt;
    private final CdsModel model;
    private final CqnAnalyzer analyzer;
    private final Set<Condition> stopConditions = new HashSet<BiPredicate>(Collections.singleton(DEFAULT_STOP_CONDITION));
    private final Deque<Projection> projectionStack = new ArrayDeque<Projection>();
    private T current;
    private T previous;

    private ProjectionResolver(CdsModel model, T statement) {
        this.model = model;
        this.analyzer = CqnAnalyzer.create((CdsModel)model);
        this.current = statement;
    }

    public static <T extends CqnStatement> ProjectionResolver<T> create(CdsModel model, T statement) {
        return new ProjectionResolver<T>(model, statement);
    }

    public ProjectionResolver<T> condition(BiPredicate resolvedCondition) {
        this.stopConditions.add(resolvedCondition);
        return this;
    }

    public ProjectionResolver<T> condition(TriPredicate resolvedCondition) {
        this.stopConditions.add(resolvedCondition);
        return this;
    }

    public ProjectionResolver<T> resolveAll() {
        while (!this.stopResolvement()) {
            this.resolve();
        }
        return this;
    }

    private boolean stopResolvement() {
        for (Condition condition : this.stopConditions) {
            boolean test = false;
            if (condition.testNext()) {
                T next = ProjectionResolver.create(this.model, this.current).resolve().getResolvedStatement();
                test = ((TriPredicate)condition).test((CqnStatement)this.previous, (CqnStatement)this.current, (CqnStatement)next);
            } else {
                test = ((BiPredicate)condition).test(this.previous, this.current);
            }
            if (!test) continue;
            return true;
        }
        return false;
    }

    public ProjectionResolver<T> resolveAliases() {
        T resolved = this.removeAliases(this.current);
        if (resolved != this.current) {
            this.finishResolvementStep(resolved);
        }
        return this;
    }

    private T removeAliases(T statement) {
        if (statement.isSelect()) {
            CdsEntity target = this.analyzer.analyze(statement.ref()).targetEntity();
            CqnStatement selectWithoutAlias = CQL.copy(statement, (Modifier)new AliasRemover(target, null));
            Map<String, String> aliasMap = this.calculateAliasMap(statement.asSelect());
            this.projectionStack.push(new Projection(null, statement.asSelect()));
            return (T)CQL.copy((CqnStatement)selectWithoutAlias, (Modifier)new AliasModifier(null, aliasMap, null));
        }
        return statement;
    }

    public ProjectionResolver<T> resolve() {
        try {
            Object resolved = this.previous == null ? this.removeAliases(this.current) : this.current;
            CdsEntity root = this.analyzer.analyze(resolved.ref()).rootEntity();
            if (root.query().isPresent() && this.isSupportedProjection(root, (CqnSelect)root.query().get())) {
                RefModifier refModifier = new RefModifier();
                int oldNumProjections = this.projectionStack.size();
                resolved = CQL.copy(resolved, (Modifier)refModifier);
                Iterator<Projection> iter = this.projectionStack.descendingIterator();
                for (int i = 0; i < oldNumProjections; ++i) {
                    iter.next();
                }
                while (iter.hasNext()) {
                    Projection projection = iter.next();
                    if (resolved.isSelect()) {
                        resolved = CQL.copy(resolved, (Modifier)new SelectionModifier(projection.getEntity(), projection.getQuery()));
                    }
                    if (resolved.isInsert() || resolved.isUpsert() || resolved.isUpdate()) {
                        new DataAliasResolver(true).resolve(projection.getEntity(), CqnStatementUtils.getEntries(resolved), new Projection(projection.getEntity(), projection.getQuery()));
                    }
                    if (CqnStatementUtils.isSelectStar(projection.getQuery().items())) continue;
                    resolved = CQL.copy(resolved, (Modifier)new ExtendedAliasModifier(projection.getEntity(), this.calculateAliasMap(projection.getQuery()), projection));
                }
                this.finishResolvementStep(resolved);
                return this;
            }
        }
        catch (UnsupportedProjectionException unsupportedProjectionException) {
            // empty catch block
        }
        if (this.previous == null) {
            this.projectionStack.clear();
        }
        this.finishResolvementStep(this.current);
        return this;
    }

    private void finishResolvementStep(T resolved) {
        this.previous = this.current;
        this.current = resolved;
    }

    private boolean isSupportedProjection(CdsEntity target, CqnSelect query) {
        List items = query.items();
        return (items.isEmpty() || this.containsStar(items) || this.hasConcreteElement(target, items)) && query.groupBy().isEmpty() && !query.having().isPresent() && !query.where().isPresent() && !query.from().isJoin() && !query.isDistinct() && !this.isTemporal(target);
    }

    private boolean containsStar(List<CqnSelectListItem> items) {
        return items.stream().anyMatch(CqnSelectListItem::isStar);
    }

    private boolean hasConcreteElement(CdsEntity target, List<CqnSelectListItem> items) {
        return this.slvs(items).anyMatch(slv -> slv.value().isRef() && this.isConcreteElementOf(target, (CqnSelectListValue)slv));
    }

    private Stream<CqnSelectListValue> slvs(List<CqnSelectListItem> items) {
        return items.stream().flatMap(CqnSelectListItem::ofValue);
    }

    private boolean isConcreteElementOf(CdsEntity entity, CqnSelectListValue slv) {
        return entity.findElement(slv.displayName()).map(e -> !e.isVirtual()).orElse(true);
    }

    private boolean isTemporal(CdsEntity entity) {
        return !this.current.isInsert() && entity.elements().anyMatch(e -> e.findAnnotation("cds.valid.from").isPresent() || e.findAnnotation("cds.valid.to").isPresent());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RefAndAliases resolveRefAndAliases(StructuredTypeRef ref, Projection currentProjection) {
        StructuredType resolvedRef = null;
        CdsEntity currentRefTarget = null;
        HashMap<String, String> previousAliasMap = new HashMap<String, String>();
        Iterator iterator = this.analyzer.analyze((CqnStructuredTypeRef)ref).iterator();
        while (iterator.hasNext()) {
            ResolvedSegment segment = (ResolvedSegment)iterator.next();
            CdsEntity segmentTarget = segment.entity();
            if (resolvedRef == null) {
                Optional queryOptional = segmentTarget.query();
                if (!queryOptional.isPresent()) return new RefAndAliases(ref, new HashMap<String, String>());
                currentRefTarget = this.analyzer.analyze((CqnSelect)queryOptional.get()).targetEntity();
                resolvedRef = CQL.entity((String)currentRefTarget.getQualifiedName());
            } else {
                String id = segment.segment().id();
                String resolvedId = previousAliasMap.getOrDefault(id, id);
                resolvedRef = resolvedRef.to(resolvedId);
                try {
                    currentRefTarget = (CdsEntity)currentRefTarget.getTargetOf(resolvedId);
                }
                catch (CdsElementNotFoundException e2) {
                    throw new UnsupportedProjectionException();
                }
            }
            CqnPredicate filter = segment.segment().filter().orElse(null);
            previousAliasMap.clear();
            Deque<Projection> projectionsToResolve = this.getProjectionStack(segmentTarget, currentRefTarget);
            Iterator<Projection> projectionIterator = projectionsToResolve.descendingIterator();
            while (projectionIterator.hasNext()) {
                Projection projection = projectionIterator.next();
                Map<String, String> aliasMap = this.calculateAliasMap(projection.getQuery());
                if (filter != null) {
                    Predicate resolvedFilter = CQL.copy((CqnPredicate)filter, (Modifier)new AliasModifier(projection.getEntity(), aliasMap, currentProjection));
                    resolvedRef = resolvedRef.filter((CqnPredicate)resolvedFilter);
                    filter = resolvedFilter;
                }
                if (!iterator.hasNext()) {
                    if (currentProjection == null) {
                        this.projectionStack.push(projection);
                    } else {
                        ArrayDeque<Projection> projections = (ArrayDeque<Projection>)currentProjection.refs.get(ref);
                        if (projections == null) {
                            projections = new ArrayDeque<Projection>();
                            currentProjection.refs.put(ref, projections);
                        }
                        projections.push(projection);
                    }
                }
                previousAliasMap.replaceAll((k, v) -> aliasMap.getOrDefault(v, (String)v));
                aliasMap.entrySet().stream().filter(e -> !previousAliasMap.containsValue(e.getKey())).forEach(e -> {
                    String cfr_ignored_0 = (String)previousAliasMap.put((String)e.getKey(), (String)e.getValue());
                });
            }
        }
        if (currentProjection == null) return new RefAndAliases(resolvedRef.asRef(), previousAliasMap);
        currentProjection.aliases.put(ref, resolvedRef.asRef());
        return new RefAndAliases(resolvedRef.asRef(), previousAliasMap);
    }

    private ElementRef<?> resolveRef(CdsEntity root, CqnElementRef ref, Projection currentProjection) {
        StructuredTypeRef structuredType = ProjectionResolver.prefix(root, ProjectionResolver.skipLast((CqnReference)ref));
        RefAndAliases resolvedRefAndAliases = this.resolveRefAndAliases(structuredType, currentProjection);
        StructuredTypeRef resolvedStructuredType = resolvedRefAndAliases.ref;
        Map aliases = resolvedRefAndAliases.aliases;
        List<CqnReference.Segment> resolvedSegments = ProjectionResolver.skipFirst((CqnReference)resolvedStructuredType);
        ElementRef result = CQL.to(resolvedSegments).get(aliases.getOrDefault(ref.lastSegment(), ref.lastSegment()));
        currentProjection.aliases.put(ref, result);
        return result;
    }

    private StructuredType<?> resolveType(CdsEntity root, CqnStructuredTypeRef ref, Projection currentProjection) {
        StructuredTypeRef structuredType = ProjectionResolver.prefix(root, ref.segments());
        RefAndAliases resolvedRefAndAliases = this.resolveRefAndAliases(structuredType, currentProjection);
        StructuredTypeRef resolvedStructuredType = resolvedRefAndAliases.ref;
        List<CqnReference.Segment> resolvedSegments = ProjectionResolver.skipFirst((CqnReference)resolvedStructuredType);
        return CQL.to(resolvedSegments);
    }

    private static StructuredTypeRef prefix(CdsEntity root, List<? extends CqnReference.Segment> list) {
        ArrayList<Object> segments = new ArrayList<Object>();
        segments.add(CQL.refSegment((String)root.getQualifiedName()));
        segments.addAll(list);
        return CQL.to(segments).asRef();
    }

    private Map<String, String> calculateAliasMap(CqnSelect query) {
        CdsEntity queryTarget = this.analyzer.analyze(query).targetEntity();
        return this.calculateAliasMap(queryTarget, query.items());
    }

    private Map<String, String> calculateAliasMap(CdsEntity queryTarget, List<CqnSelectListItem> items) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        items.stream().flatMap(CqnSelectListItem::ofValue).forEach(slv -> {
            String alias = slv.alias().orElse(null);
            if (alias != null) {
                CqnValue val = slv.value();
                if (val.isRef()) {
                    CqnElementRef ref = val.asRef();
                    String original = ref.segments().stream().map(s -> s.id()).collect(Collectors.joining("."));
                    aliasMap.put(alias, original);
                    boolean singleValuedAssociation = CdsModelUtils.findElement((CdsStructuredType)queryTarget, ref).map(e -> e.getType().isAssociation() && CdsModelUtils.isSingleValued(e.getType())).orElse(true);
                    if (singleValuedAssociation) {
                        String prefix = original + "_";
                        queryTarget.elements().map(e -> e.getName()).filter(e -> e.startsWith(prefix)).forEach(e -> {
                            String elementInStruct = e.substring(prefix.length() - 1);
                            aliasMap.put(alias + elementInStruct, (String)e);
                        });
                    }
                } else {
                    aliasMap.put(alias, UNKNOWN);
                }
            }
        });
        return aliasMap;
    }

    public T getResolvedStatement() {
        return this.current;
    }

    public List<? extends Map<String, Object>> transform(List<? extends Map<String, Object>> entries) {
        if (this.projectionStack.isEmpty()) {
            return entries;
        }
        List copy = DataUtils.copyGenericList(entries);
        DataAliasResolver dataAliasResolver = new DataAliasResolver(false);
        CdsEntity target = this.analyzer.analyze(this.current.ref()).targetEntity();
        for (Projection projection : this.projectionStack) {
            dataAliasResolver.resolve(target, copy, projection);
            target = projection.getEntity();
        }
        return copy;
    }

    public Result transform(Result result) {
        if (this.projectionStack.isEmpty()) {
            return result;
        }
        List<Map<String, Object>> transformedResult = this.transform(result.list());
        ResultImpl builder = ResultImpl.from(result).rows(transformedResult);
        if (this.current.isSelect()) {
            builder.rowType(CqnStatementUtils.rowType(this.model, this.projectionStack.getLast().getQuery()));
        }
        return builder.result();
    }

    private static List<? extends CqnReference.Segment> skipFirst(CqnReference ref) {
        List segments = ref.segments();
        return segments.subList(1, segments.size());
    }

    private static List<? extends CqnReference.Segment> skipLast(CqnReference ref) {
        List segments = ref.segments();
        return segments.subList(0, segments.size() - 1);
    }

    private Deque<Projection> getProjectionStack(CdsEntity top, CdsEntity bottom) {
        Optional optQuery;
        LinkedList<Projection> stack = new LinkedList<Projection>();
        CdsEntity currentEntity = top;
        while (!currentEntity.getQualifiedName().equals(bottom.getQualifiedName()) && (optQuery = currentEntity.query()).isPresent()) {
            if (!this.isSupportedProjection(currentEntity, (CqnSelect)optQuery.get())) {
                throw new UnsupportedProjectionException();
            }
            stack.push(new Projection(currentEntity, (CqnSelect)optQuery.get()));
            currentEntity = this.analyzer.analyze((CqnSelect)optQuery.get()).targetEntity();
        }
        return stack;
    }

    private static class UnsupportedProjectionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private UnsupportedProjectionException() {
        }
    }

    private static class Projection {
        private final CdsEntity entity;
        private final CqnSelect query;
        private Map<CqnStructuredTypeRef, Deque<Projection>> refs = new HashMap<CqnStructuredTypeRef, Deque<Projection>>();
        private Map<CqnReference, CqnReference> aliases = new HashMap<CqnReference, CqnReference>();

        public Projection(CdsEntity entity, CqnSelect query) {
            this.entity = entity;
            this.query = query;
        }

        public CdsEntity getEntity() {
            return this.entity;
        }

        public CqnSelect getQuery() {
            return this.query;
        }
    }

    @FunctionalInterface
    public static interface TriPredicate
    extends Condition {
        public boolean test(CqnStatement var1, CqnStatement var2, CqnStatement var3);

        @Override
        default public boolean testNext() {
            return true;
        }
    }

    @FunctionalInterface
    public static interface BiPredicate
    extends Condition,
    java.util.function.BiPredicate<CqnStatement, CqnStatement> {
    }

    private static interface Condition {
        default public boolean testNext() {
            return false;
        }
    }

    private class DataAliasResolver {
        private final boolean forwardMapping;

        public DataAliasResolver(boolean forwardMapping) {
            this.forwardMapping = forwardMapping;
        }

        public void resolve(CdsEntity target, List<? extends Map<String, Object>> entries, Projection projection) {
            if (projection.refs.isEmpty()) {
                target.associations().forEach(a -> this.resolveAssociation(entries, projection, (CdsElement)a));
            } else {
                projection.refs.entrySet().forEach(refEntry -> this.resolveExpandedEntities(entries, projection, (Map.Entry<CqnStructuredTypeRef, Deque<Projection>>)refEntry));
            }
            Map aliasMap = ProjectionResolver.this.calculateAliasMap(projection.getQuery());
            projection.aliases.entrySet().forEach(entry -> aliasMap.putIfAbsent(((CqnReference)entry.getKey()).lastSegment(), ((CqnReference)entry.getValue()).lastSegment()));
            CdsEntity projectedType = this.forwardMapping ? ProjectionResolver.this.analyzer.analyze(projection.getQuery()).targetEntity() : projection.getEntity();
            entries.forEach(entry -> {
                HashMap renamedEntry = new HashMap();
                entry.forEach((key, value) -> {
                    String mapping = this.getMapping((String)key, aliasMap);
                    if (projectedType == null || CdsModelUtils.findElement((CdsStructuredType)target, (CqnElementRef)CQL.get((String)key)).isPresent() == CdsModelUtils.findElement((CdsStructuredType)projectedType, (CqnElementRef)CQL.get((String)mapping)).isPresent() || aliasMap.containsKey(mapping) && ((String)aliasMap.get(mapping)).split("\\.").length > 1) {
                        renamedEntry.put(mapping, value);
                    }
                });
                entry.clear();
                entry.putAll(renamedEntry);
            });
        }

        private void resolveExpandedEntities(List<? extends Map<String, Object>> entries, Projection projection, Map.Entry<CqnStructuredTypeRef, Deque<Projection>> refEntry) {
            CqnReference ref = (CqnReference)projection.aliases.get(refEntry.getKey());
            String name = ref.lastSegment();
            List<Map<String, Object>> associationEntries = this.getAssociationEntries(entries, name);
            if (associationEntries.isEmpty()) {
                return;
            }
            for (Projection childProjection : refEntry.getValue()) {
                CdsEntity childProjectionTarget = CqnAnalyzer.create((CdsModel)ProjectionResolver.this.model).analyze(childProjection.getQuery()).targetEntity();
                this.resolve(childProjectionTarget, associationEntries, childProjection);
            }
        }

        private void resolveAssociation(List<? extends Map<String, Object>> entries, Projection projection, CdsElement a) {
            Iterator iter;
            String associationName = a.getName();
            CdsEntity associationTarget = ((CdsAssociationType)a.getType().as(CdsAssociationType.class)).getTarget();
            List<Map<String, Object>> associationEntries = this.getAssociationEntries(entries, associationName);
            if (associationEntries.isEmpty()) {
                return;
            }
            String resolvedAssociationName = this.getMapping(associationName, projection);
            Deque<Projection> associationProjections = new LinkedList();
            CdsEntity resolvedTarget = this.getResolvedTarget(projection, this.forwardMapping);
            if (resolvedTarget != null && this.hasAssociation(resolvedTarget, resolvedAssociationName)) {
                CdsEntity resolvedAssociationTarget = (CdsEntity)resolvedTarget.getTargetOf(resolvedAssociationName);
                associationProjections = ProjectionResolver.this.getProjectionStack(this.forwardMapping ? associationTarget : resolvedAssociationTarget, this.forwardMapping ? resolvedAssociationTarget : associationTarget);
            } else {
                for (CqnSelectListItem item : projection.getQuery().items()) {
                    if (!item.isExpand() || !item.asExpand().displayName().equals(resolvedAssociationName)) continue;
                    associationProjections.add(new Projection(null, (CqnSelect)Select.from((CdsEntity)associationTarget).columns(item.asExpand().items())));
                    break;
                }
            }
            Iterator iterator = iter = this.forwardMapping ? associationProjections.descendingIterator() : associationProjections.iterator();
            while (iter.hasNext()) {
                Projection associationProjection = (Projection)iter.next();
                this.resolve(this.getResolvedTarget(associationProjection, !this.forwardMapping), associationEntries, associationProjection);
            }
        }

        private boolean hasAssociation(CdsEntity target, String associationName) {
            return !ProjectionResolver.UNKNOWN.equals(associationName) && target.findElement(associationName).filter(e -> e.getType().isAssociation()).isPresent();
        }

        private List<Map<String, Object>> getAssociationEntries(List<? extends Map<String, Object>> entries, String name) {
            ArrayList<Map<String, Object>> associationEntries = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> map : entries) {
                Object value = map.get(name);
                if (value instanceof Map) {
                    associationEntries.add((Map)value);
                    continue;
                }
                if (!(value instanceof List)) continue;
                associationEntries.addAll((List)value);
            }
            return associationEntries;
        }

        private String getMapping(String key, Projection projection) {
            return this.getMapping(key, ProjectionResolver.this.calculateAliasMap(projection.getQuery()));
        }

        private String getMapping(String key, Map<String, String> aliasMap) {
            if (this.forwardMapping) {
                return aliasMap.getOrDefault(key, key);
            }
            return aliasMap.entrySet().stream().filter(e -> ((String)e.getValue()).equals(key)).map(e -> (String)e.getKey()).findFirst().orElse(aliasMap.entrySet().stream().filter(e -> this.getLastSegment((String)e.getValue()).equals(key)).map(e -> (String)e.getKey()).findFirst().orElse(key));
        }

        private CdsEntity getResolvedTarget(Projection projection, boolean forward) {
            if (forward) {
                return ProjectionResolver.this.analyzer.analyze(projection.getQuery()).targetEntity();
            }
            return projection.getEntity();
        }

        private String getLastSegment(String segments) {
            if (segments == null || segments.isEmpty()) {
                return segments;
            }
            String[] segmentArray = segments.split("\\.");
            return segmentArray[segmentArray.length - 1];
        }
    }

    private class ExtendedAliasModifier
    extends AliasModifier {
        public ExtendedAliasModifier(CdsEntity target, Map<String, String> aliasMap, Projection currentProjection) {
            super(target, aliasMap, currentProjection);
        }

        public CqnSelectListItem expand(Expand<?> expand) {
            StructuredTypeRef ref = expand.ref();
            List items = expand.items();
            List orderBy = expand.orderBy();
            StructuredType resolvedType = ProjectionResolver.this.resolveType(this.target, (CqnStructuredTypeRef)ref, this.currentProjection);
            Optional<Deque> projections = this.currentProjection.refs.entrySet().stream().filter(arg_0 -> ExtendedAliasModifier.lambda$expand$0((CqnStructuredTypeRef)ref, arg_0)).map(e -> (Deque)e.getValue()).findAny();
            if (!projections.isPresent()) {
                return resolvedType.expand((Iterable)items).orderBy(orderBy).limit(expand.top(), expand.skip());
            }
            CdsEntity expandTarget = (CdsEntity)CdsModelUtils.target((CdsStructuredType)this.target, ref.asRef().segments()).as(CdsEntity.class);
            List resolvedItems = items;
            List resolvedOrderBy = orderBy;
            Iterator descendingIterator = projections.get().descendingIterator();
            while (descendingIterator.hasNext()) {
                Projection currentProjection = (Projection)descendingIterator.next();
                CqnSelect expandQuery = currentProjection.getQuery();
                List<CqnSelectListItem> expandedItems = new SelectionModifier(expandTarget, expandQuery).items(resolvedItems);
                ExtendedAliasModifier aliasModifier = new ExtendedAliasModifier(expandTarget, ProjectionResolver.this.calculateAliasMap(expandQuery), currentProjection);
                resolvedItems = expandedItems.stream().map(i -> ExpressionVisitor.copy(i, (Modifier)aliasModifier)).collect(Collectors.toList());
                resolvedOrderBy = resolvedOrderBy.stream().map(o -> ExpressionVisitor.copy(o, (Modifier)aliasModifier)).collect(Collectors.toList());
                expandTarget = CdsModelUtils.entity(ProjectionResolver.this.model, expandQuery.ref());
            }
            return resolvedType.expand((Iterable)resolvedItems).orderBy(resolvedOrderBy).limit(expand.top(), expand.skip());
        }

        public Set<String> excluding(Set<String> excluding) {
            return excluding.stream().map(e -> this.aliasMap.getOrDefault(e, e)).collect(Collectors.toSet());
        }

        private static /* synthetic */ boolean lambda$expand$0(CqnStructuredTypeRef ref, Map.Entry e) {
            return ProjectionResolver.skipFirst((CqnReference)e.getKey()).equals(ref.segments());
        }
    }

    private class RefModifier
    implements Modifier {
        private RefModifier() {
        }

        public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
            return ProjectionResolver.this.resolveRefAndAliases(ref, null).ref;
        }
    }

    private class SelectionModifier
    implements Modifier {
        private final CdsEntity target;
        private final CqnSelect query;
        private final Map<String, String> aliasMap;
        private final CdsEntity projectionTarget;

        public SelectionModifier(CdsEntity target, CqnSelect query) {
            this.target = target;
            this.query = query;
            this.aliasMap = ProjectionResolver.this.calculateAliasMap(query);
            this.projectionTarget = ProjectionResolver.this.analyzer.analyze(query).targetEntity();
        }

        public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
            ArrayList<CqnSelectListItem> slis;
            HashSet<String> selected;
            boolean hasExpandStar;
            block13: {
                block12: {
                    if (CqnStatementUtils.isSelectStar(this.query.items())) {
                        return items;
                    }
                    boolean hasStar = false;
                    hasExpandStar = false;
                    selected = new HashSet<String>();
                    slis = new ArrayList<CqnSelectListItem>();
                    for (CqnSelectListItem item : items) {
                        if (item.isStar()) {
                            hasStar = true;
                            continue;
                        }
                        if (item.isExpand() && item.asExpand().ref().firstSegment().equals("*")) {
                            hasExpandStar = true;
                            continue;
                        }
                        String displayName = null;
                        if (item.isValue()) {
                            displayName = item.asValue().displayName();
                        } else if (item.isExpand()) {
                            displayName = item.asExpand().displayName();
                        }
                        if (displayName != null && !this.isAllowedSelection(displayName)) continue;
                        if (displayName != null) {
                            selected.add(displayName);
                        }
                        slis.add(item);
                    }
                    if (hasStar) break block12;
                    if (!items.isEmpty()) break block13;
                }
                this.target.concreteNonAssociationElements().filter(e -> this.isAllowedSelection(e.getName())).filter(e -> !selected.contains(e.getName())).map(e -> CQL.get((String)e.getName())).forEach(slis::add);
            }
            if (hasExpandStar) {
                this.target.associations().filter(a -> !a.isVirtual()).filter(e -> this.isAllowedSelection(e.getName())).filter(e -> !selected.contains(e.getName())).map(e -> CQL.to((String)e.getName()).expand()).forEach(slis::add);
            }
            return slis;
        }

        public Set<String> excluding(Set<String> excluding) {
            HashSet<String> all = new HashSet<String>(excluding);
            all.addAll(this.query.excluding());
            return all;
        }

        private boolean isAllowedSelection(String element) {
            boolean existsOnNextLevel;
            String mapped = this.aliasMap.getOrDefault(element, element);
            boolean existsOnThisLevel = CdsModelUtils.findElement((CdsStructuredType)this.target, (CqnElementRef)CQL.get((String)element)).isPresent();
            return existsOnThisLevel == (existsOnNextLevel = CdsModelUtils.findElement((CdsStructuredType)this.projectionTarget, (CqnElementRef)CQL.get((String)mapped)).isPresent());
        }
    }

    private class AliasModifier
    implements Modifier {
        protected final CdsEntity target;
        protected final Map<String, String> aliasMap;
        protected final Projection currentProjection;

        public AliasModifier(CdsEntity target, Map<String, String> aliasMap, Projection currentProjection) {
            this.target = target;
            this.aliasMap = aliasMap;
            this.currentProjection = currentProjection;
        }

        public Value<?> ref(ElementRef<?> ref) {
            if (ref.segments().size() == 1) {
                String id = ref.firstSegment();
                return CQL.get((String)this.aliasMap.getOrDefault(id, id));
            }
            if (this.target != null) {
                return ProjectionResolver.this.resolveRef(this.target, ref, this.currentProjection);
            }
            return super.ref(ref);
        }
    }

    private class AliasRemover
    implements Modifier {
        private final CdsEntity target;
        private final Projection currentProjection;

        public AliasRemover(CdsEntity target, Projection currentProjection) {
            this.target = target;
            this.currentProjection = currentProjection;
        }

        public CqnSelectListItem selectListItem(Value<?> value, String alias) {
            if (value.isRef() && alias != null) {
                return CQL.get((String)alias);
            }
            return super.selectListValue(value, alias);
        }

        public CqnSelectListItem expand(Expand<?> expand) {
            List items = expand.items();
            StructuredTypeRef ref = expand.ref();
            if (ref.firstSegment().equals("*")) {
                return expand;
            }
            CdsEntity expandTarget = (CdsEntity)CdsModelUtils.target((CdsStructuredType)this.target, ref.segments()).as(CdsEntity.class);
            AliasRemover aliasRemover = new AliasRemover(expandTarget, this.currentProjection);
            List unaliasedItems = items.stream().map(i -> ExpressionVisitor.copy(i, (Modifier)aliasRemover)).collect(Collectors.toList());
            Map expandAliasMap = ProjectionResolver.this.calculateAliasMap(expandTarget, items);
            AliasModifier aliasModifier = new AliasModifier(null, expandAliasMap, this.currentProjection);
            List resolvedItems = unaliasedItems.stream().map(i -> ExpressionVisitor.copy(i, (Modifier)aliasModifier)).collect(Collectors.toList());
            List resolvedOrderBy = expand.orderBy().stream().map(o -> ExpressionVisitor.copy(o, (Modifier)aliasModifier)).collect(Collectors.toList());
            return CQL.to((List)ref.segments()).expand(resolvedItems).orderBy(resolvedOrderBy).limit(expand.top(), expand.skip());
        }
    }

    private static class RefAndAliases {
        private final StructuredTypeRef ref;
        private final Map<String, String> aliases;

        public RefAndAliases(StructuredTypeRef ref, Map<String, String> aliases) {
            this.ref = ref;
            this.aliases = aliases;
        }
    }
}

