/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.sap.cds.SessionContext;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.util.CdsModelUtils;
import java.util.Optional;
import java.util.function.Supplier;

public class SessionUtils {
    public static Optional<SessionContextVariable> getSessionParameter(CqnElementRef ref, SessionContext sessionContext) {
        SessionContextVariable sessionVariable = null;
        if (CdsModelUtils.isContextElementRef(ref)) {
            switch (ref.firstSegment()) {
                case "$now": {
                    sessionVariable = new SessionContextVariable(() -> sessionContext.getNow(), CdsBaseType.TIMESTAMP);
                    break;
                }
                case "$at": {
                    if (ref.lastSegment().equalsIgnoreCase("from")) {
                        sessionVariable = new SessionContextVariable(() -> sessionContext.getValidFrom(), CdsBaseType.TIMESTAMP);
                        break;
                    }
                    if (ref.lastSegment().equalsIgnoreCase("to")) {
                        sessionVariable = new SessionContextVariable(() -> sessionContext.getValidTo(), CdsBaseType.TIMESTAMP);
                        break;
                    }
                    throw SessionUtils.badRef(ref);
                }
                case "$user": {
                    if (ref.lastSegment().equalsIgnoreCase("locale")) {
                        sessionVariable = new SessionContextVariable(() -> LocaleUtils.getLocaleString(sessionContext.getLocale()), CdsBaseType.STRING);
                        break;
                    }
                    if (ref.lastSegment().equalsIgnoreCase("id")) {
                        sessionVariable = new SessionContextVariable(() -> sessionContext.getUserContext().getId(), CdsBaseType.STRING);
                        break;
                    }
                    throw SessionUtils.badRef(ref);
                }
                default: {
                    throw SessionUtils.badRef(ref);
                }
            }
        }
        return Optional.ofNullable(sessionVariable);
    }

    private static CqnSyntaxException badRef(CqnElementRef ref) {
        return new CqnSyntaxException("The reference " + ref.toJson() + " can't be resolved");
    }

    public static class SessionContextVariable {
        Supplier<Object> valueSupplier;
        CdsBaseType type;

        public SessionContextVariable(Supplier<Object> valueSupplier, CdsBaseType type) {
            this.valueSupplier = valueSupplier;
            this.type = type;
        }

        public Supplier<Object> getValueSupplier() {
            return this.valueSupplier;
        }

        public CdsBaseType getType() {
            return this.type;
        }
    }
}

