/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.CdsException;
import com.sap.cds.reflect.CdsDefinitionNotFoundException;
import com.sap.cds.reflect.CdsKind;
import java.util.Map;

public class StructuredTypeResolver {
    private final Map<String, JsonNode> structuredObjects;

    public StructuredTypeResolver(Map<String, JsonNode> structuredObjects) {
        this.structuredObjects = structuredObjects;
    }

    private static JsonNode extractNode(JsonNode entityNode, String elementName) {
        if (entityNode != null) {
            JsonNode elementsNode;
            JsonNode elementNode;
            if (entityNode.has("elements") && (elementNode = (elementsNode = entityNode.get("elements")).get(elementName)) != null) {
                return elementNode;
            }
            return null;
        }
        throw new CdsDefinitionNotFoundException(CdsKind.TYPE, elementName);
    }

    public JsonNode getElementNode(ArrayNode arrayNode) {
        int size = arrayNode.size();
        String defName = arrayNode.get(0).asText();
        if (size < 2) {
            throw new CdsException("TypeRef contains invalid number of arguments");
        }
        if (size == 2 && this.structuredObjects.containsKey(defName)) {
            JsonNode entityNode = this.structuredObjects.get(defName);
            return StructuredTypeResolver.extractNode(entityNode, arrayNode.get(1).asText());
        }
        JsonNode currNode = this.structuredObjects.get(defName);
        for (int i = 1; i < size; ++i) {
            currNode = StructuredTypeResolver.extractNode(currNode, arrayNode.get(i).asText());
        }
        return currNode;
    }
}

