/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.neonbee.NeonBeeDeployable;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.cluster.ClusterManagerFactory;
import io.neonbee.config.HealthConfig;
import io.neonbee.config.NeonBeeConfig;
import io.neonbee.config.ServerConfig;
import io.neonbee.data.DataException;
import io.neonbee.data.DataQuery;
import io.neonbee.entity.EntityModelManager;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.health.AbstractHealthCheck;
import io.neonbee.health.EventLoopHealthCheck;
import io.neonbee.health.HazelcastClusterHealthCheck;
import io.neonbee.health.HealthCheckProvider;
import io.neonbee.health.HealthCheckRegistry;
import io.neonbee.health.MemoryHealthCheck;
import io.neonbee.health.internal.HealthCheck;
import io.neonbee.hook.HookRegistry;
import io.neonbee.hook.HookType;
import io.neonbee.hook.internal.DefaultHookRegistry;
import io.neonbee.internal.SharedDataAccessor;
import io.neonbee.internal.buffer.ImmutableBuffer;
import io.neonbee.internal.codec.DataExceptionMessageCodec;
import io.neonbee.internal.codec.DataQueryMessageCodec;
import io.neonbee.internal.codec.EntityWrapperMessageCodec;
import io.neonbee.internal.codec.ImmutableBufferMessageCodec;
import io.neonbee.internal.codec.ImmutableJsonArrayMessageCodec;
import io.neonbee.internal.codec.ImmutableJsonObjectMessageCodec;
import io.neonbee.internal.deploy.Deployable;
import io.neonbee.internal.deploy.DeployableModule;
import io.neonbee.internal.deploy.DeployableVerticle;
import io.neonbee.internal.deploy.Deployables;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.helper.FileSystemHelper;
import io.neonbee.internal.helper.HostHelper;
import io.neonbee.internal.json.ImmutableJsonArray;
import io.neonbee.internal.json.ImmutableJsonObject;
import io.neonbee.internal.scanner.DeployableScanner;
import io.neonbee.internal.scanner.HookScanner;
import io.neonbee.internal.tracking.MessageDirection;
import io.neonbee.internal.tracking.TrackingDataHandlingStrategy;
import io.neonbee.internal.tracking.TrackingDataLoggingStrategy;
import io.neonbee.internal.tracking.TrackingInterceptor;
import io.neonbee.internal.verticle.ConsolidationVerticle;
import io.neonbee.internal.verticle.DeployerVerticle;
import io.neonbee.internal.verticle.HealthCheckVerticle;
import io.neonbee.internal.verticle.LoggerManagerVerticle;
import io.neonbee.internal.verticle.MetricsVerticle;
import io.neonbee.internal.verticle.ModelRefreshVerticle;
import io.neonbee.internal.verticle.ServerVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeonBee {
    private static final String CORRELATION_ID = "Initializing-NeonBee";
    private static final Logger LOGGER = LoggerFactory.getLogger(NeonBee.class);
    private static final Map<Vertx, NeonBee> NEONBEE_INSTANCES = new HashMap<Vertx, NeonBee>();
    private static final String SHARED_MAP_NAME = "#sharedMap";
    private static final int NUMBER_DEFAULT_INSTANCES = 4;
    @VisibleForTesting
    final NeonBeeConfig config;
    private final String nodeId = UUID.randomUUID().toString();
    private final Vertx vertx;
    private final NeonBeeOptions options;
    private final HookRegistry hookRegistry;
    private final HealthCheckRegistry healthRegistry;
    private LocalMap<String, Object> sharedLocalMap;
    private AsyncMap<String, Object> sharedAsyncMap;
    private final Set<String> localConsumers = new ConcurrentHashSet();
    private final EntityModelManager modelManager;
    private final CompositeMeterRegistry compositeMeterRegistry;

    public static NeonBee get() {
        Context context = Vertx.currentContext();
        return context != null ? NeonBee.get(context.owner()) : null;
    }

    public static NeonBee get(Vertx vertx) {
        return NEONBEE_INSTANCES.get(vertx);
    }

    public static Future<NeonBee> create() {
        return NeonBee.create(new NeonBeeOptions.Mutable());
    }

    public static Future<NeonBee> create(NeonBeeOptions options) {
        return NeonBee.create(options, null);
    }

    public static Future<NeonBee> create(NeonBeeOptions options, NeonBeeConfig config) {
        return NeonBee.create(vertxOptions -> NeonBee.newVertx(vertxOptions, options), options.getClusterManager(), options, config);
    }

    @VisibleForTesting
    static Future<NeonBee> create(Function<VertxOptions, Future<Vertx>> vertxFactory, ClusterManagerFactory clusterManagerFactory, NeonBeeOptions options, NeonBeeConfig config) {
        try {
            Files.createDirectories(options.getLogDirectory(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VertxOptions vertxOptions = new VertxOptions().setEventLoopPoolSize(options.getEventLoopPoolSize()).setWorkerPoolSize(options.getWorkerPoolSize());
        CompositeMeterRegistry compositeMeterRegistry = new CompositeMeterRegistry();
        vertxOptions.setMetricsOptions((MetricsOptions)new MicrometerMetricsOptions().setRegistryName(options.getMetricsRegistryName()).setMicrometerRegistry((MeterRegistry)compositeMeterRegistry).setEnabled(true));
        Future loadClusterManager = Future.future(p -> {
            if (options.isClustered()) {
                p.handle((AsyncResult)clusterManagerFactory.create(options).map(arg_0 -> ((VertxOptions)vertxOptions).setClusterManager(arg_0)));
            } else {
                p.complete((Object)vertxOptions);
            }
        });
        return loadClusterManager.compose(vertxFactory).compose(vertx -> {
            Function<Throwable, Future> closeVertx = throwable -> {
                if (!(vertxFactory instanceof OwnVertxFactory)) {
                    LOGGER.error("Failure during bootstrap phase.", throwable);
                    return Future.failedFuture((Throwable)throwable);
                }
                LOGGER.error("Failure during bootstrap phase. Shutting down Vert.x instance.", throwable);
                return vertx.close().transform(closeResult -> Future.failedFuture((Throwable)throwable));
            };
            try {
                Future<NeonBeeConfig> neonBeeConfigFuture = config == null ? NeonBee.loadConfig(vertx, options.getConfigDirectory()) : Future.succeededFuture((Object)config);
                Future neonBeeFuture = neonBeeConfigFuture.map(c -> new NeonBee((Vertx)vertx, options, (NeonBeeConfig)c, compositeMeterRegistry));
                return neonBeeFuture.compose(NeonBee::boot).recover(closeVertx).compose(unused -> neonBeeFuture);
            }
            catch (Throwable t) {
                return closeVertx.apply(t).mapEmpty();
            }
        });
    }

    @VisibleForTesting
    static Future<Vertx> newVertx(VertxOptions vertxOptions, NeonBeeOptions options) {
        if (!options.isClustered()) {
            return Future.succeededFuture((Object)Vertx.vertx((VertxOptions)vertxOptions));
        }
        vertxOptions.getEventBusOptions().setPort(options.getClusterPort());
        Optional.ofNullable(HostHelper.getHostIp()).filter(Predicate.not(String::isEmpty)).ifPresent(currentIp -> vertxOptions.getEventBusOptions().setHost(currentIp));
        return Vertx.clusteredVertx((VertxOptions)vertxOptions).onFailure(throwable -> LOGGER.error("Failed to start clustered Vert.x", throwable));
    }

    private Future<Void> boot() {
        LOGGER.info("Booting NeonBee (ID: {})", (Object)this.nodeId);
        return this.registerHooks().compose(nothing -> this.hookRegistry.executeHooks(HookType.BEFORE_BOOTSTRAP)).onSuccess(anything -> TimeZone.setDefault(TimeZone.getTimeZone(this.config.getTimeZone()))).compose(nothing -> CompositeFuture.all(this.initializeSharedMaps(), this.decorateEventBus(), this.createMicrometerRegistries())).compose(nothing -> CompositeFuture.all(this.deployVerticles(), this.deployModules())).compose(nothing -> this.registerHealthChecks()).compose(nothing -> this.hookRegistry.executeHooks(HookType.AFTER_STARTUP)).onSuccess(result -> LOGGER.info("Successfully booted NeonBee (ID: {}})!", (Object)this.nodeId)).mapEmpty();
    }

    @VisibleForTesting
    Future<Void> registerHealthChecks() {
        ArrayList<Future<HealthCheck>> healthChecks = new ArrayList<Future<HealthCheck>>();
        if (Optional.ofNullable(this.config.getHealthConfig()).map(HealthConfig::isEnabled).orElse(true).booleanValue()) {
            VertxInternal vertxInternal;
            healthChecks.add(this.healthRegistry.register(new MemoryHealthCheck(this)));
            healthChecks.add(this.healthRegistry.register(new EventLoopHealthCheck(this)));
            if (this.vertx instanceof VertxInternal && (vertxInternal = (VertxInternal)this.vertx).getClusterManager() instanceof HazelcastClusterManager) {
                HazelcastClusterManager cm = (HazelcastClusterManager)vertxInternal.getClusterManager();
                healthChecks.add(this.healthRegistry.register(new HazelcastClusterHealthCheck(this, cm)));
            }
            ServiceLoader.load(HealthCheckProvider.class).forEach(provider -> provider.get(this.vertx).forEach(check -> {
                if (!this.healthRegistry.getHealthChecks().containsKey(check.getId())) {
                    healthChecks.add(this.healthRegistry.register((AbstractHealthCheck)check));
                }
            }));
        }
        return AsyncHelper.joinComposite(healthChecks).recover(v -> {
            healthChecks.stream().filter(Future::failed).map(Future::cause).forEach(t -> LOGGER.error("Failed to register health checks to registry.", t));
            return Future.succeededFuture();
        }).mapEmpty();
    }

    private Future<Void> registerHooks() {
        if (this.options.shouldIgnoreClassPath()) {
            return Future.succeededFuture();
        }
        return new HookScanner().scanForHooks(this.vertx).compose(hookClasses -> AsyncHelper.allComposite(hookClasses.stream().map(hookClass -> this.hookRegistry.registerHooks((Class<?>)hookClass, CORRELATION_ID)).collect(Collectors.toList())).mapEmpty());
    }

    @VisibleForTesting
    Future<Void> initializeSharedMaps() {
        SharedDataAccessor sharedData = new SharedDataAccessor(this.vertx, NeonBee.class);
        this.sharedLocalMap = sharedData.getLocalMap(SHARED_MAP_NAME);
        return sharedData.getAsyncMap(SHARED_MAP_NAME).onSuccess(asyncMap -> {
            this.sharedAsyncMap = asyncMap;
        }).mapEmpty();
    }

    @VisibleForTesting
    Future<Void> decorateEventBus() {
        return AsyncHelper.executeBlocking(this.vertx, () -> {
            TrackingDataHandlingStrategy strategy;
            try {
                strategy = (TrackingDataHandlingStrategy)Class.forName(this.config.getTrackingDataHandlingStrategy()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Failed to load configured tracking handling strategy {}. Use default.", (Object)this.config.getTrackingDataHandlingStrategy(), (Object)e);
                }
                strategy = new TrackingDataLoggingStrategy();
            }
            this.vertx.eventBus().addInboundInterceptor((Handler)new TrackingInterceptor(MessageDirection.INBOUND, strategy)).addOutboundInterceptor((Handler)new TrackingInterceptor(MessageDirection.OUTBOUND, strategy));
            this.vertx.eventBus().registerDefaultCodec(DataQuery.class, (MessageCodec)new DataQueryMessageCodec()).registerDefaultCodec(EntityWrapper.class, (MessageCodec)new EntityWrapperMessageCodec(this.vertx)).registerDefaultCodec(ImmutableBuffer.class, (MessageCodec)new ImmutableBufferMessageCodec()).registerDefaultCodec(ImmutableJsonArray.class, (MessageCodec)new ImmutableJsonArrayMessageCodec()).registerDefaultCodec(ImmutableJsonObject.class, (MessageCodec)new ImmutableJsonObjectMessageCodec()).registerDefaultCodec(DataException.class, (MessageCodec)new DataExceptionMessageCodec());
            this.config.getEventBusCodecs().forEach(this::registerCodec);
        });
    }

    private void registerCodec(String className, String codecClassName) {
        try {
            this.vertx.eventBus().registerDefaultCodec(Class.forName(className), (MessageCodec)Class.forName(codecClassName).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register codec {} for class {}", new Object[]{codecClassName, className, e});
        }
    }

    @VisibleForTesting
    Future<Void> createMicrometerRegistries() {
        return CompositeFuture.all(this.config.createMicrometerRegistries(this.vertx).collect(Collectors.toList())).onSuccess(h -> h.list().forEach(arg_0 -> ((CompositeMeterRegistry)this.compositeMeterRegistry).add(arg_0))).mapEmpty();
    }

    private Future<Void> deployVerticles() {
        Set<NeonBeeProfile> activeProfiles = this.options.getActiveProfiles();
        if (LOGGER.isInfoEnabled()) {
            if (!activeProfiles.isEmpty()) {
                LOGGER.info("Deploying verticle with active profiles: {}", (Object)activeProfiles.stream().map(Enum::name).collect(Collectors.joining(", ")));
            } else {
                LOGGER.info("No active profiles, only deploying system verticles");
            }
        }
        ArrayList<Future<Void>> deployFutures = new ArrayList<Future<Void>>();
        deployFutures.add(this.deploySystemVerticles());
        if (NeonBeeProfile.WEB.isActive(activeProfiles)) {
            deployFutures.add(this.deployServerVerticle());
        }
        deployFutures.add(this.deployClassPathVerticles());
        return AsyncHelper.allComposite(deployFutures).mapEmpty();
    }

    private Future<Void> deploySystemVerticles() {
        ArrayList<Future<? extends Deployable>> requiredVerticles = new ArrayList<Future<? extends Deployable>>();
        requiredVerticles.add(DeployableVerticle.fromClass(this.vertx, ConsolidationVerticle.class, new JsonObject().put("instances", (Object)1)));
        requiredVerticles.add(DeployableVerticle.fromVerticle(this.vertx, (Verticle)new MetricsVerticle(1L, TimeUnit.SECONDS)));
        requiredVerticles.add(DeployableVerticle.fromVerticle(this.vertx, (Verticle)new HealthCheckVerticle()));
        requiredVerticles.add(DeployableVerticle.fromClass(this.vertx, LoggerManagerVerticle.class));
        ArrayList<Future<Optional<? extends Deployable>>> optionalVerticles = new ArrayList<Future<Optional<? extends Deployable>>>();
        optionalVerticles.add(this.deployableWatchVerticle(this.options.getModelsDirectory(), ModelRefreshVerticle::new));
        optionalVerticles.add(this.deployableWatchVerticle(this.options.getVerticlesDirectory(), DeployerVerticle::new));
        optionalVerticles.add(this.deployableWatchVerticle(this.options.getModulesDirectory(), DeployerVerticle::new));
        LOGGER.info("Deploying system verticles ...");
        return AsyncHelper.allComposite(List.of(Deployables.fromDeployables(requiredVerticles).compose(Deployables.allTo(this)), AsyncHelper.allComposite(optionalVerticles).map(CompositeFuture::list).map(optionals -> optionals.stream().map(Optional.class::cast).filter(Optional::isPresent).map(Optional::get).map(Deployable.class::cast).collect(Collectors.toList())).map(Deployables::new).compose(Deployables.anyTo(this)))).mapEmpty();
    }

    private Future<Optional<? extends Deployable>> deployableWatchVerticle(Path dirPath, Function<Path, ? extends Verticle> verticleFactory) {
        if (this.options.doNotWatchFiles()) {
            return Future.succeededFuture(Optional.empty());
        }
        return FileSystemHelper.exists(this.vertx, dirPath).compose(exists -> {
            if (Boolean.FALSE.equals(exists)) {
                if (LOGGER.isWarnEnabled()) {
                    String dirName = dirPath.getFileName().toString();
                    LOGGER.warn("No " + dirName + " directory, " + dirName + " are not being watched");
                }
                return Future.succeededFuture(Optional.empty());
            }
            return DeployableVerticle.fromVerticle(this.vertx, (Verticle)verticleFactory.apply(dirPath)).map(Optional::of);
        });
    }

    private Future<Void> deployServerVerticle() {
        LOGGER.info("Deploying server verticle ...");
        return DeployableVerticle.fromClass(this.vertx, ServerVerticle.class, new JsonObject().put("instances", (Object)4)).compose(deployable -> deployable.deploy(this)).mapEmpty();
    }

    private Future<Void> deployClassPathVerticles() {
        if (this.options.shouldIgnoreClassPath()) {
            return Future.succeededFuture();
        }
        LOGGER.info("Deploying verticle(s) from class path ...");
        return DeployableScanner.scanForDeployableClasses(this.vertx).compose(deployableClasses -> Deployables.fromDeployables(deployableClasses.stream().filter(verticleClass -> NeonBee.filterByAutoDeployAndProfiles(verticleClass, this.options.getActiveProfiles())).map(verticleClass -> DeployableVerticle.fromClass(this.vertx, verticleClass)).collect(Collectors.toList()))).onSuccess(deployables -> {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Deploy class path verticle(s) {}.", (Object)deployables.getIdentifier());
            }
        }).compose(Deployables.allTo(this)).mapEmpty();
    }

    @VisibleForTesting
    static boolean filterByAutoDeployAndProfiles(Class<? extends Verticle> verticleClass, Collection<NeonBeeProfile> activeProfiles) {
        NeonBeeDeployable annotation = verticleClass.getAnnotation(NeonBeeDeployable.class);
        return annotation.autoDeploy() && annotation.profile().isActive(activeProfiles);
    }

    private Future<Void> deployModules() {
        List<Path> moduleJarPaths = this.options.getModuleJarPaths();
        if (moduleJarPaths.isEmpty()) {
            return Future.succeededFuture();
        }
        LOGGER.info("Deploying module(s) ...");
        return Deployables.fromDeployables(moduleJarPaths.stream().map(moduleJarPath -> DeployableModule.fromJar(this.vertx, moduleJarPath)).collect(Collectors.toList())).compose(Deployables.allTo(this)).mapEmpty();
    }

    @VisibleForTesting
    NeonBee(Vertx vertx, NeonBeeOptions options, NeonBeeConfig config, CompositeMeterRegistry compositeMeterRegistry) {
        this.vertx = vertx;
        this.options = options;
        this.config = config;
        this.healthRegistry = new HealthCheckRegistry(vertx);
        this.modelManager = new EntityModelManager(this);
        this.compositeMeterRegistry = compositeMeterRegistry;
        NEONBEE_INSTANCES.put(vertx, this);
        this.hookRegistry = new DefaultHookRegistry(vertx);
        this.registerCloseHandler(vertx);
    }

    @VisibleForTesting
    static Future<NeonBeeConfig> loadConfig(Vertx vertx, Path configPath) {
        LOGGER.info("Loading NeonBee configuration ...");
        return NeonBeeConfig.load(vertx, configPath).onSuccess(config -> {
            LOGGER.info("Successfully loaded NeonBee configuration");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loaded configuration {}", config);
            }
        }).onFailure(throwable -> LOGGER.error("Failed to load NeonBee configuration", throwable));
    }

    private void registerCloseHandler(Vertx vertx) {
        try {
            vertx.getClass().getMethod("addCloseHook", Closeable.class).invoke((Object)vertx, handler -> handler.handle((AsyncResult)this.hookRegistry.executeHooks(HookType.BEFORE_SHUTDOWN).compose(shutdownHooksExecutionOutcomes -> {
                if (shutdownHooksExecutionOutcomes.failed()) {
                    shutdownHooksExecutionOutcomes.list().stream().filter(Future::failed).forEach(future -> LOGGER.error("Shutdown hook execution failed", future.cause()));
                }
                NEONBEE_INSTANCES.remove(vertx);
                return Future.succeededFuture();
            }).mapEmpty()));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register NeonBee close hook to Vert.x", (Throwable)e);
        }
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public NeonBeeOptions getOptions() {
        return this.options;
    }

    public NeonBeeConfig getConfig() {
        return this.config;
    }

    public LocalMap<String, Object> getLocalMap() {
        return this.sharedLocalMap;
    }

    public AsyncMap<String, Object> getAsyncMap() {
        return this.sharedAsyncMap;
    }

    public HookRegistry getHookRegistry() {
        return this.hookRegistry;
    }

    public boolean isLocalConsumerAvailable(String targetVerticle) {
        return this.localConsumers.contains(targetVerticle);
    }

    public void registerLocalConsumer(String verticleAddress) {
        this.localConsumers.add(verticleAddress);
    }

    public void unregisterLocalConsumer(String verticleAddress) {
        this.localConsumers.remove(verticleAddress);
    }

    public ServerConfig getServerConfig() {
        return new ServerConfig((JsonObject)this.getLocalMap().get((Object)"__ServerVerticleConfig__"));
    }

    public EntityModelManager getModelManager() {
        return this.modelManager;
    }

    public CompositeMeterRegistry getCompositeMeterRegistry() {
        return this.compositeMeterRegistry;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public HealthCheckRegistry getHealthCheckRegistry() {
        return this.healthRegistry;
    }

    @VisibleForTesting
    static interface OwnVertxFactory
    extends Function<VertxOptions, Future<Vertx>> {
    }
}

