/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeProfile;
import io.neonbee.cluster.ClusterManagerFactory;
import io.neonbee.internal.helper.FileSystemHelper;
import io.vertx.core.VertxOptions;
import io.vertx.core.cli.annotations.ConvertedBy;
import io.vertx.core.cli.annotations.DefaultValue;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.cli.converters.Converter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public interface NeonBeeOptions {
    public int getEventLoopPoolSize();

    public int getWorkerPoolSize();

    public String getInstanceName();

    public Path getWorkingDirectory();

    default public Path getConfigDirectory() {
        return this.getWorkingDirectory().resolve("config");
    }

    @Deprecated
    default public Path getVerticlesDirectory() {
        return this.getWorkingDirectory().resolve("verticles");
    }

    default public Path getModulesDirectory() {
        return this.getWorkingDirectory().resolve("modules");
    }

    default public Path getModelsDirectory() {
        return this.getWorkingDirectory().resolve("models");
    }

    default public Path getLogDirectory() {
        return this.getWorkingDirectory().resolve("logs");
    }

    public boolean shouldIgnoreClassPath();

    public boolean shouldDisableJobScheduling();

    public boolean doNotWatchFiles();

    public int getClusterPort();

    public boolean isClustered();

    public String getClusterConfig();

    public ClusterManagerFactory getClusterManager();

    public Integer getServerPort();

    public Set<NeonBeeProfile> getActiveProfiles();

    public List<Path> getModuleJarPaths();

    public String getMetricsRegistryName();

    public static class ClusterManagerFactoryConverter
    implements Converter<ClusterManagerFactory> {
        public ClusterManagerFactory fromString(String s) {
            if ("hazelcast".equalsIgnoreCase(s)) {
                return ClusterManagerFactory.HAZELCAST_FACTORY;
            }
            if ("infinispan".equalsIgnoreCase(s)) {
                return ClusterManagerFactory.INFINISPAN_FACTORY;
            }
            throw new IllegalArgumentException("Value for cluster-manager MUST be \"hazelcast\" or \"infinispan\".");
        }
    }

    public static class PathConverter
    implements Converter<Path> {
        public Path fromString(String s) {
            return Path.of(s, new String[0]);
        }
    }

    @Name(value="neonbee")
    @Summary(value="A command line interface for starting and configuring a NeonBee and its associated Vert.x instance")
    public static class Mutable
    implements NeonBeeOptions {
        public static final String DEFAULT_ACTIVE_PROFILES = "ALL";
        private int eventLoopPoolSize = VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE;
        private int workerPoolSize = 20;
        private int clusterPort = 0;
        private boolean clustered;
        private String clusterConfig;
        private ClusterManagerFactory clusterManagerFactory = ClusterManagerFactory.HAZELCAST_FACTORY;
        private String instanceName;
        private Path workingDirectoryPath = Path.of("", new String[0]);
        private boolean ignoreClassPath;
        private boolean disableJobScheduling;
        private boolean doNotWatchFiles;
        private Integer serverPort;
        private Set<NeonBeeProfile> activeProfiles = NeonBeeProfile.parseProfiles("ALL");
        private List<Path> moduleJarPaths = Collections.emptyList();
        private String metricsRegistryName = "default";

        public Mutable() {
            this.instanceName = this.generateName();
        }

        @Override
        public int getEventLoopPoolSize() {
            return this.eventLoopPoolSize;
        }

        @Option(longName="event-loop-pool-size", shortName="elps")
        @Description(value="Set the number of threads for the event loop pool")
        public Mutable setEventLoopPoolSize(int eventLoopPoolSize) {
            if (eventLoopPoolSize < 1) {
                throw new IllegalArgumentException("eventLoopSize must be > 0");
            }
            this.eventLoopPoolSize = eventLoopPoolSize;
            return this;
        }

        @Override
        public int getWorkerPoolSize() {
            return this.workerPoolSize;
        }

        @Option(longName="worker-pool-size", shortName="wps")
        @Description(value="Set the number of threads for the worker pool")
        public Mutable setWorkerPoolSize(int workerPoolSize) {
            if (workerPoolSize < 1) {
                throw new IllegalArgumentException("workerPoolSize must be > 0");
            }
            this.workerPoolSize = workerPoolSize;
            return this;
        }

        @Override
        public String getInstanceName() {
            return this.instanceName;
        }

        @Option(longName="instance-name", shortName="name")
        @Description(value="Set the instance name")
        public Mutable setInstanceName(String instanceName) {
            if (Objects.isNull(instanceName)) {
                this.instanceName = this.generateName();
            } else {
                if (instanceName.isEmpty()) {
                    throw new IllegalArgumentException("instanceName must not be empty");
                }
                this.instanceName = instanceName;
            }
            return this;
        }

        @Override
        public Path getWorkingDirectory() {
            return this.workingDirectoryPath;
        }

        @Option(longName="working-directory", shortName="cwd")
        @Description(value="Set the current working directory")
        @DefaultValue(value="./working_dir/")
        @ConvertedBy(value=PathConverter.class)
        public Mutable setWorkingDirectory(Path workingDirectory) {
            Objects.requireNonNull(workingDirectory, "workingDirectory must not be null");
            this.workingDirectoryPath = workingDirectory.toAbsolutePath().normalize();
            return this;
        }

        @Override
        public boolean shouldIgnoreClassPath() {
            return this.ignoreClassPath;
        }

        @Option(longName="ignore-class-path", shortName="no-cp", flag=true)
        @Description(value="Set whether to ignore verticle and models on the class path or not")
        public Mutable setIgnoreClassPath(boolean ignoreClassPath) {
            this.ignoreClassPath = ignoreClassPath;
            return this;
        }

        @Override
        public boolean shouldDisableJobScheduling() {
            return this.disableJobScheduling;
        }

        @Option(longName="disable-job-scheduling", shortName="no-jobs", flag=true)
        @Description(value="Set whether to schedule any job verticles or not")
        public Mutable setDisableJobScheduling(boolean disableJobScheduling) {
            this.disableJobScheduling = disableJobScheduling;
            return this;
        }

        @Override
        public boolean doNotWatchFiles() {
            return this.doNotWatchFiles;
        }

        @Option(longName="do-not-watch-files", shortName="no-watchers", flag=true)
        @Description(value="Set whether to watch any files")
        public Mutable setDoNotWatchFiles(boolean doNotWatchFiles) {
            this.doNotWatchFiles = doNotWatchFiles;
            return this;
        }

        @Override
        public boolean isClustered() {
            return this.clustered;
        }

        @Option(longName="clustered", shortName="cl", flag=true)
        @Description(value="Set whether to start in clustered mode or not")
        public Mutable setClustered(boolean clustered) {
            this.clustered = clustered;
            return this;
        }

        @Override
        public int getClusterPort() {
            return this.clusterPort;
        }

        @Option(longName="cluster-port", shortName="clp")
        @Description(value="Set the port of cluster event bus")
        public Mutable setClusterPort(int clusterPort) {
            this.clusterPort = clusterPort;
            return this;
        }

        @Override
        public String getClusterConfig() {
            return this.clusterConfig;
        }

        @Option(longName="cluster-config", shortName="cc")
        @Description(value="Set the cluster configuration file path")
        public Mutable setClusterConfig(String clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        @Override
        public ClusterManagerFactory getClusterManager() {
            return this.clusterManagerFactory;
        }

        @Option(longName="cluster-manager", shortName="cm")
        @Description(value="Set the cluster manager \"infinispan\" or \"hazelcast\" (default)")
        @DefaultValue(value="hazelcast")
        @ConvertedBy(value=ClusterManagerFactoryConverter.class)
        public Mutable setClusterManager(ClusterManagerFactory clusterManagerFactory) {
            this.clusterManagerFactory = clusterManagerFactory;
            return this;
        }

        @Override
        public Integer getServerPort() {
            return this.serverPort;
        }

        @Option(longName="server-port", shortName="port")
        @Description(value="Set the HTTP(S) port of server")
        public Mutable setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        @Override
        public Set<NeonBeeProfile> getActiveProfiles() {
            return this.activeProfiles;
        }

        public Mutable setActiveProfiles(Collection<NeonBeeProfile> profiles) {
            this.activeProfiles = ImmutableSet.copyOf(Objects.requireNonNull(profiles));
            return this;
        }

        @Option(longName="active-profiles", shortName="ap", acceptMultipleValues=true)
        @DefaultValue(value="ALL")
        @Description(value="Set the active deployment profiles")
        public Mutable setActiveProfiles(String ... activeProfiles) {
            return this.setActiveProfiles(Arrays.stream(activeProfiles).map(NeonBeeProfile::parseProfiles).flatMap(Collection::stream).collect(Collectors.toSet()));
        }

        public Mutable addActiveProfile(NeonBeeProfile profile) {
            return this.addActiveProfiles(profile);
        }

        public Mutable addActiveProfiles(NeonBeeProfile ... profiles) {
            this.activeProfiles = Sets.union(this.activeProfiles, Set.of(profiles));
            return this;
        }

        public Mutable removeActiveProfile(NeonBeeProfile profile) {
            return this.removeActiveProfiles(profile);
        }

        public Mutable removeActiveProfiles(NeonBeeProfile ... profiles) {
            this.activeProfiles = Sets.difference(this.activeProfiles, Set.of(profiles));
            return this;
        }

        public Mutable clearActiveProfiles() {
            this.activeProfiles = Set.of();
            return this;
        }

        @Override
        public List<Path> getModuleJarPaths() {
            return this.moduleJarPaths;
        }

        public Mutable setModuleJarPaths(List<Path> moduleJarPaths) {
            this.moduleJarPaths = ImmutableList.copyOf((Collection)Objects.requireNonNull(moduleJarPaths));
            return this;
        }

        @Option(longName="module-jar-paths", shortName="mjp")
        @Description(value="A list of path(s) to module JARs to be loaded during startup")
        public Mutable setModuleJarPaths(String ... moduleJarPaths) {
            return this.setModuleJarPaths(Arrays.stream(moduleJarPaths).map(xva$0 -> FileSystemHelper.parsePaths(xva$0)).flatMap(Collection::stream).collect(Collectors.toList()));
        }

        @Override
        public String getMetricsRegistryName() {
            return this.metricsRegistryName;
        }

        public Mutable setMetricsRegistryName(String registryName) {
            this.metricsRegistryName = registryName;
            return this;
        }

        private String generateName() {
            return String.format("%s-%s", NeonBee.class.getSimpleName(), UUID.randomUUID().toString());
        }
    }
}

