/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.cluster;

import com.google.common.base.Strings;
import com.hazelcast.config.ClasspathXmlConfig;
import com.hazelcast.config.Config;
import io.neonbee.NeonBeeOptions;
import io.vertx.core.Future;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.cluster.infinispan.InfinispanClusterManager;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.io.IOException;
import org.infinispan.manager.DefaultCacheManager;

public abstract class ClusterManagerFactory {
    public static final ClusterManagerFactory HAZELCAST_FACTORY = new ClusterManagerFactory(){

        @Override
        protected String getDefaultConfig() {
            return "hazelcast-cf.xml";
        }

        @Override
        public Future<ClusterManager> create(NeonBeeOptions neonBeeOptions) {
            String effectiveConfig = this.getEffectiveConfig(neonBeeOptions);
            return Future.succeededFuture((Object)new HazelcastClusterManager((Config)new ClasspathXmlConfig(ClassLoader.getSystemClassLoader(), effectiveConfig, System.getProperties())));
        }
    };
    public static final ClusterManagerFactory INFINISPAN_FACTORY = new ClusterManagerFactory(){

        @Override
        protected String getDefaultConfig() {
            return "infinispan-local.xml";
        }

        @Override
        public Future<ClusterManager> create(NeonBeeOptions neonBeeOptions) {
            String effectiveConfig = this.getEffectiveConfig(neonBeeOptions);
            try {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                return Future.succeededFuture((Object)new InfinispanClusterManager(new DefaultCacheManager(effectiveConfig, true)));
            }
            catch (IOException e) {
                return Future.failedFuture((Throwable)e);
            }
        }
    };

    protected String getEffectiveConfig(NeonBeeOptions options) {
        return Strings.isNullOrEmpty((String)options.getClusterConfig()) ? this.getDefaultConfig() : options.getClusterConfig();
    }

    protected abstract String getDefaultConfig();

    public abstract Future<ClusterManager> create(NeonBeeOptions var1);
}

