/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import com.google.common.collect.ImmutableBiMap;
import com.google.errorprone.annotations.Immutable;
import io.neonbee.config.AuthHandlerConfigConverter;
import io.neonbee.config.AuthProviderConfig;
import io.neonbee.internal.helper.ConfigHelper;
import io.neonbee.internal.json.ImmutableJsonObject;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.DigestAuthHandler;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.RedirectAuthHandler;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataObject(generateConverter=true, publicConverter=false)
public class AuthHandlerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ImmutableBiMap<String, String> REPHRASE_MAP = ImmutableBiMap.of((Object)"authProviderConfig", (Object)"provider");
    private AuthHandlerType type;
    private AuthProviderConfig authProviderConfig;
    private JsonObject additionalConfig = new JsonObject();

    public AuthHandlerConfig() {
    }

    public AuthHandlerConfig(JsonObject json) {
        this();
        JsonObject newJson = ConfigHelper.rephraseConfigNames(json.copy(), REPHRASE_MAP, true);
        AuthHandlerConfigConverter.fromJson((Iterable<Map.Entry<String, Object>>)newJson, this);
        this.additionalConfig.mergeIn(ConfigHelper.collectAdditionalConfig(newJson, "type", "authProviderConfig"));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        AuthHandlerConfigConverter.toJson(this, json);
        json.mergeIn(this.additionalConfig);
        ConfigHelper.rephraseConfigNames(json, REPHRASE_MAP, false);
        return json;
    }

    public AuthHandlerType getType() {
        return this.type;
    }

    @Fluent
    public AuthHandlerConfig setType(AuthHandlerType type) {
        this.type = type;
        return this;
    }

    public AuthProviderConfig getAuthProviderConfig() {
        return this.authProviderConfig;
    }

    @Fluent
    public AuthHandlerConfig setAuthProviderConfig(AuthProviderConfig authProviderConfig) {
        this.authProviderConfig = authProviderConfig;
        return this;
    }

    @GenIgnore
    public JsonObject getAdditionalConfig() {
        return this.additionalConfig;
    }

    @Fluent
    @GenIgnore
    public AuthHandlerConfig setAdditionalConfig(JsonObject additionalConfig) {
        this.additionalConfig = Optional.ofNullable(additionalConfig).orElseGet(JsonObject::new);
        return this;
    }

    public AuthenticationHandler createAuthHandler(Vertx vertx) {
        return this.type.createAuthHandler(vertx, this.authProviderConfig, this.additionalConfig);
    }

    public int hashCode() {
        return Objects.hash(this.additionalConfig, this.authProviderConfig, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthHandlerConfig)) {
            return false;
        }
        AuthHandlerConfig other = (AuthHandlerConfig)obj;
        return Objects.equals(this.additionalConfig, other.additionalConfig) && Objects.equals(this.authProviderConfig, other.authProviderConfig) && this.type == other.type;
    }

    @Immutable
    public static enum AuthHandlerType implements AuthHandlerFactory
    {
        BASIC((vertx, authProviderConfig, additionalConfig) -> BasicAuthHandler.create((AuthenticationProvider)authProviderConfig.createAuthProvider(vertx), (String)additionalConfig.getString("realm", "vertx-web"))),
        HTDIGEST((vertx, authProviderConfig, additionalConfig) -> {
            if (!AuthProviderConfig.AuthProviderType.HTDIGEST.equals(authProviderConfig.getType())) {
                throw new IllegalArgumentException("Cannot configure a digest authentication handler with any other authentication provider type");
            }
            return DigestAuthHandler.create((Vertx)vertx, (HtdigestAuth)((HtdigestAuth)authProviderConfig.createAuthProvider(vertx)));
        }),
        JWT((vertx, authProviderConfig, additionalConfig) -> {
            if (!AuthProviderConfig.AuthProviderType.JWT.equals(authProviderConfig.getType())) {
                throw new IllegalArgumentException("Cannot configure a JWT authentication handler with any other authentication provider type");
            }
            return JWTAuthHandler.create((JWTAuth)((JWTAuth)authProviderConfig.createAuthProvider(vertx)));
        }),
        OAUTH2((vertx, authProviderConfig, additionalConfig) -> {
            if (!AuthProviderConfig.AuthProviderType.OAUTH2.equals(authProviderConfig.getType())) {
                throw new IllegalArgumentException("Cannot configure a JWT authentication handler with any other authentication provider type");
            }
            return OAuth2AuthHandler.create((Vertx)vertx, (OAuth2Auth)((OAuth2Auth)authProviderConfig.createAuthProvider(vertx)), (String)additionalConfig.getString("callbackURL"));
        }),
        REDIRECT((vertx, authProviderConfig, additionalConfig) -> RedirectAuthHandler.create((AuthenticationProvider)authProviderConfig.createAuthProvider(vertx), (String)additionalConfig.getString("loginRedirectURL", "/loginpage"), (String)additionalConfig.getString("returnURLParam", "return_url")));

        final AuthHandlerFactory factory;

        private AuthHandlerType(AuthHandlerFactory factory) {
            this.factory = factory;
        }

        @Override
        public AuthenticationHandler createAuthHandler(Vertx vertx, AuthProviderConfig providerConfig, JsonObject additionalConfig) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Configuring auth. handler {} with options: {}", (Object)this, (Object)additionalConfig);
            }
            return this.factory.createAuthHandler(vertx, providerConfig, Optional.ofNullable(additionalConfig).orElse(ImmutableJsonObject.EMPTY));
        }
    }

    @FunctionalInterface
    @Immutable
    private static interface AuthHandlerFactory {
        public AuthenticationHandler createAuthHandler(Vertx var1, AuthProviderConfig var2, JsonObject var3);
    }
}

