/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import com.google.common.collect.ImmutableBiMap;
import io.micrometer.core.instrument.MeterRegistry;
import io.neonbee.NeonBee;
import io.neonbee.config.HealthConfig;
import io.neonbee.config.MetricsConfig;
import io.neonbee.config.MicrometerRegistryConfig;
import io.neonbee.config.NeonBeeConfigConverter;
import io.neonbee.config.metrics.MicrometerRegistryLoader;
import io.neonbee.internal.helper.ConfigHelper;
import io.neonbee.internal.tracking.TrackingDataLoggingStrategy;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@DataObject(generateConverter=true, publicConverter=false)
public class NeonBeeConfig {
    public static final int DEFAULT_EVENT_BUS_TIMEOUT = 30;
    public static final String DEFAULT_TRACKING_DATA_HANDLING_STRATEGY = TrackingDataLoggingStrategy.class.getName();
    public static final String DEFAULT_TIME_ZONE = "UTC";
    private static final ImmutableBiMap<String, String> REPHRASE_MAP = ImmutableBiMap.of((Object)"healthConfig", (Object)"health", (Object)"metricsConfig", (Object)"metrics");
    private int eventBusTimeout = 30;
    private Map<String, String> eventBusCodecs = Map.of();
    private String trackingDataHandlingStrategy = DEFAULT_TRACKING_DATA_HANDLING_STRATEGY;
    private List<String> platformClasses = List.of("io.vertx.*", "io.neonbee.*", "org.slf4j.*", "org.apache.olingo.*");
    private String timeZone = "UTC";
    private List<MicrometerRegistryConfig> micrometerRegistries = List.of();
    private HealthConfig healthConfig = new HealthConfig();
    private MetricsConfig metricsConfig = new MetricsConfig();

    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    @Fluent
    public NeonBeeConfig setMetricsConfig(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
        return this;
    }

    public static Future<NeonBeeConfig> load(Vertx vertx, Path path) {
        return ConfigHelper.readConfig(vertx, NeonBee.class.getName(), path).recover(ConfigHelper.notFound(() -> Future.succeededFuture((Object)new JsonObject()))).map(NeonBeeConfig::new);
    }

    public static Future<NeonBeeConfig> load(Vertx vertx) {
        return ConfigHelper.readConfig(vertx, NeonBee.class.getName(), new JsonObject()).map(NeonBeeConfig::new);
    }

    public NeonBeeConfig() {
    }

    public NeonBeeConfig(JsonObject json) {
        this();
        JsonObject newJson = ConfigHelper.rephraseConfigNames(json.copy(), REPHRASE_MAP, true);
        NeonBeeConfigConverter.fromJson((Iterable<Map.Entry<String, Object>>)newJson, this);
    }

    public HealthConfig getHealthConfig() {
        return this.healthConfig;
    }

    @Fluent
    public NeonBeeConfig setHealthConfig(HealthConfig healthConfig) {
        this.healthConfig = healthConfig;
        return this;
    }

    public Stream<Future<MeterRegistry>> createMicrometerRegistries(Vertx vertx) {
        return this.micrometerRegistries.stream().filter(micrometerRegistryConfig -> micrometerRegistryConfig.getClassName() != null).filter(micrometerRegistryConfig -> !micrometerRegistryConfig.getClassName().isBlank()).map(micrometerRegistryConfig -> this.instantiateLoader(micrometerRegistryConfig.getClassName()).compose(micrometerRegistryLoader -> Future.future(promise -> micrometerRegistryLoader.load(vertx, micrometerRegistryConfig.getConfig(), (Promise<MeterRegistry>)promise))));
    }

    @Deprecated(forRemoval=true)
    public Collection<MeterRegistry> createMicrometerRegistries() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ArrayList<MeterRegistry> registries = new ArrayList<MeterRegistry>(this.micrometerRegistries.size());
        for (MicrometerRegistryConfig micrometerRegistryConfig : this.micrometerRegistries) {
            String className = micrometerRegistryConfig.getClassName();
            if (className == null || className.isBlank()) continue;
            Class<?> classObject = Class.forName(className);
            if (!MicrometerRegistryLoader.class.isAssignableFrom(classObject)) {
                throw new IllegalArgumentException(classObject.getName() + " must implement " + MicrometerRegistryLoader.class.getName());
            }
            MicrometerRegistryLoader loader = (MicrometerRegistryLoader)classObject.getConstructor(new Class[0]).newInstance(new Object[0]);
            registries.add(loader.load(micrometerRegistryConfig.getConfig()));
        }
        return registries;
    }

    private Future<MicrometerRegistryLoader> instantiateLoader(String className) {
        return Future.future(promise -> {
            try {
                Class<?> classObject = Class.forName(className);
                if (!MicrometerRegistryLoader.class.isAssignableFrom(classObject)) {
                    promise.fail((Throwable)new IllegalArgumentException(classObject.getName() + " must implement " + MicrometerRegistryLoader.class.getName()));
                }
                promise.complete((Object)((MicrometerRegistryLoader)classObject.getConstructor(new Class[0]).newInstance(new Object[0])));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                promise.fail((Throwable)e);
            }
        });
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        NeonBeeConfigConverter.toJson(this, json);
        ConfigHelper.rephraseConfigNames(json, REPHRASE_MAP, false);
        return json;
    }

    public int getEventBusTimeout() {
        return this.eventBusTimeout;
    }

    @Fluent
    public NeonBeeConfig setEventBusTimeout(int eventBusTimeout) {
        this.eventBusTimeout = eventBusTimeout;
        return this;
    }

    public Map<String, String> getEventBusCodecs() {
        return this.eventBusCodecs;
    }

    @Fluent
    public NeonBeeConfig setEventBusCodecs(Map<String, String> eventBusCodecs) {
        this.eventBusCodecs = eventBusCodecs;
        return this;
    }

    public String getTrackingDataHandlingStrategy() {
        return this.trackingDataHandlingStrategy;
    }

    @Fluent
    public NeonBeeConfig setTrackingDataHandlingStrategy(String trackingDataHandlingStrategy) {
        this.trackingDataHandlingStrategy = trackingDataHandlingStrategy;
        return this;
    }

    public List<String> getPlatformClasses() {
        return this.platformClasses;
    }

    @Fluent
    public NeonBeeConfig setPlatformClasses(List<String> platformClasses) {
        this.platformClasses = platformClasses;
        return this;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    @Fluent
    public NeonBeeConfig setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Fluent
    public NeonBeeConfig setMicrometerRegistries(List<MicrometerRegistryConfig> micrometerRegistries) {
        this.micrometerRegistries = micrometerRegistries;
        return this;
    }

    public List<MicrometerRegistryConfig> getMicrometerRegistries() {
        return this.micrometerRegistries;
    }
}

