/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data;

import io.neonbee.data.DataRequest;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.internal.helper.FunctionalHelper;
import io.vertx.core.AsyncResult;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class DataMap
extends AbstractMap<DataRequest, AsyncResult<?>>
implements AsyncResult<DataMap> {
    private Set<Map.Entry<DataRequest, AsyncResult<?>>> entries;

    public DataMap(Map<DataRequest, AsyncResult<?>> map) {
        this(map.entrySet());
    }

    public DataMap(Set<Map.Entry<DataRequest, AsyncResult<?>>> entries) {
        this.entries = entries;
    }

    @Override
    public Set<Map.Entry<DataRequest, AsyncResult<?>>> entrySet() {
        return this.entries;
    }

    public <U> Optional<AsyncResult<U>> findFirst(String qualifiedName) {
        return this.entryStream(qualifiedName).findFirst().map(Map.Entry::getValue);
    }

    public Optional<AsyncResult<EntityWrapper>> findFirst(String entityTypeNamespace, String entityTypeName) {
        return this.entryStream(entityTypeNamespace, entityTypeName).findFirst().map(Map.Entry::getValue);
    }

    public Optional<AsyncResult<EntityWrapper>> findFirst(FullQualifiedName entityTypeName) {
        return this.entryStream(entityTypeName).findFirst().map(Map.Entry::getValue);
    }

    public <U> List<AsyncResult<U>> findAll(String qualifiedName) {
        return this.entryStream(qualifiedName).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<AsyncResult<EntityWrapper>> findAll(String entityTypeNamespace, String entityTypeName) {
        return this.entryStream(entityTypeNamespace, entityTypeName).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<AsyncResult<EntityWrapper>> findAll(FullQualifiedName entityTypeName) {
        return this.entryStream(entityTypeName).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private Optional<AsyncResult<?>> findAnyFailed() {
        return this.entryStream().map(Map.Entry::getValue).filter(AsyncResult::failed).findAny();
    }

    private Optional<AsyncResult<?>> findAnyFailed(String qualifiedName) {
        return this.entryStream(qualifiedName).map(Map.Entry::getValue).filter(AsyncResult::failed).findAny();
    }

    private Optional<AsyncResult<?>> findAnyFailed(String entityTypeNamespace, String entityTypeName) {
        return this.entryStream(entityTypeNamespace, entityTypeName).map(Map.Entry::getValue).filter(AsyncResult::failed).findAny();
    }

    private Optional<AsyncResult<?>> findAnyFailed(FullQualifiedName entityTypeName) {
        return this.entryStream(entityTypeName).map(Map.Entry::getValue).filter(AsyncResult::failed).findAny();
    }

    public DataMap subMap(String qualifiedName) {
        return new DataMap(this.entryStream(qualifiedName).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public DataMap subMap(String entityTypeNamespace, String entityTypeName) {
        return new DataMap(this.entryStream(entityTypeNamespace, entityTypeName).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public DataMap subMap(FullQualifiedName entityTypeName) {
        return new DataMap(this.entryStream(entityTypeName).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    private Stream<Map.Entry<DataRequest, AsyncResult<?>>> entryStream() {
        return this.entries.stream();
    }

    private <U> Stream<Map.Entry<DataRequest, AsyncResult<U>>> entryStream(String qualifiedName) {
        return this.entryStream().filter(entry -> qualifiedName.equals(((DataRequest)entry.getKey()).getQualifiedName())).map(FunctionalHelper::uncheckedMapper);
    }

    private Stream<Map.Entry<DataRequest, AsyncResult<EntityWrapper>>> entryStream(String entityTypeNamespace, String entityTypeName) {
        return this.entryStream().filter(entry -> {
            FullQualifiedName entryEntityTypeName = ((DataRequest)entry.getKey()).getEntityTypeName();
            return entityTypeNamespace.equals(entryEntityTypeName.getNamespace()) && entityTypeName.equals(entryEntityTypeName.getName());
        }).map(FunctionalHelper::uncheckedMapper);
    }

    private Stream<Map.Entry<DataRequest, AsyncResult<EntityWrapper>>> entryStream(FullQualifiedName entityTypeName) {
        return this.entryStream().filter(entry -> entityTypeName.equals((Object)((DataRequest)entry.getKey()).getEntityTypeName())).map(FunctionalHelper::uncheckedMapper);
    }

    public DataMap result() {
        return this;
    }

    public <U> U resultFor(String qualifiedName) {
        return this.findFirst(qualifiedName).map(AsyncResult::result).orElse(null);
    }

    public EntityWrapper resultFor(String entityTypeNamespace, String entityTypeName) {
        return this.findFirst(entityTypeNamespace, entityTypeName).map(AsyncResult::result).orElse(null);
    }

    public EntityWrapper resultFor(FullQualifiedName entityTypeName) {
        return this.findFirst(entityTypeName).map(AsyncResult::result).orElse(null);
    }

    public List<?> results() {
        return this.entryStream().map(Map.Entry::getValue).map(AsyncResult::result).collect(Collectors.toList());
    }

    public <U> List<U> resultsFor(String qualifiedName) {
        return this.entryStream(qualifiedName).map(Map.Entry::getValue).map(AsyncResult::result).collect(Collectors.toList());
    }

    public List<EntityWrapper> resultsFor(String entityTypeNamespace, String entityTypeName) {
        return this.entryStream(entityTypeNamespace, entityTypeName).map(Map.Entry::getValue).map(AsyncResult::result).collect(Collectors.toList());
    }

    public List<EntityWrapper> resultsFor(FullQualifiedName entityTypeName) {
        return this.entryStream(entityTypeName).map(Map.Entry::getValue).map(AsyncResult::result).collect(Collectors.toList());
    }

    public boolean succeeded() {
        return !this.failed();
    }

    public boolean succeeded(String qualifiedName) {
        return !this.failed(qualifiedName);
    }

    public boolean succeeded(String entityTypeNamespace, String entityTypeName) {
        return !this.failed(entityTypeNamespace, entityTypeName);
    }

    public boolean succeeded(FullQualifiedName entityTypeName) {
        return !this.failed(entityTypeName);
    }

    public boolean failed() {
        return this.findAnyFailed().isPresent();
    }

    public boolean failed(String qualifiedName) {
        return this.findAnyFailed(qualifiedName).isPresent();
    }

    public boolean failed(String entityTypeNamespace, String entityTypeName) {
        return this.findAnyFailed(entityTypeNamespace, entityTypeName).isPresent();
    }

    public boolean failed(FullQualifiedName entityTypeName) {
        return this.findAnyFailed(entityTypeName).isPresent();
    }

    public Throwable cause() {
        return this.findAnyFailed().map(AsyncResult::cause).orElse(null);
    }

    public Throwable cause(String qualifiedName) {
        return this.findAnyFailed(qualifiedName).map(AsyncResult::cause).orElse(null);
    }

    public Throwable cause(String entityTypeNamespace, String entityTypeName) {
        return this.findAnyFailed(entityTypeNamespace, entityTypeName).map(AsyncResult::cause).orElse(null);
    }

    public Throwable cause(FullQualifiedName entityTypeName) {
        return this.findAnyFailed(entityTypeName).map(AsyncResult::cause).orElse(null);
    }
}

