/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Tag;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeDeployable;
import io.neonbee.config.MetricsConfig;
import io.neonbee.data.DataAction;
import io.neonbee.data.DataAdapter;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataException;
import io.neonbee.data.DataMap;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.DataSink;
import io.neonbee.data.DataSource;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.data.internal.metrics.ConfiguredDataVerticleMetrics;
import io.neonbee.data.internal.metrics.DataVerticleMetrics;
import io.neonbee.entity.EntityVerticle;
import io.neonbee.internal.helper.FunctionalHelper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public abstract class DataVerticle<T>
extends AbstractVerticle
implements DataAdapter<T> {
    public static final String CONTEXT_HEADER = "context";
    public static final String CONFIG_METRICS_KEY = "metrics";
    static final String RESOLUTION_STRATEGY_HEADER = "resolutionStrategy";
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final String SUCCEEDED_RESPONSE_COUNT = "succeeded response count";
    private final Supplier<String> namespaceSupplier = () -> Optional.ofNullable(this.getClass().getAnnotation(NeonBeeDeployable.class)).map(NeonBeeDeployable::namespace).map(Strings::emptyToNull).map(String::toLowerCase).orElse(null);
    private DataVerticleMetrics dataVerticleMetrics;

    public static <U> Future<U> requestData(Vertx vertx, DataRequest request, DataContext context) {
        DataSource<?> dataSource = request.getDataSource();
        if (dataSource != null) {
            return dataSource.retrieveData(request.getQuery(), context).map(FunctionalHelper::uncheckedMapper);
        }
        DataSink<?> dataSink = request.getDataSink();
        if (dataSink != null) {
            return dataSink.manipulateData(request.getQuery(), context).map(FunctionalHelper::uncheckedMapper);
        }
        String qualifiedName = request.getQualifiedName();
        if (qualifiedName != null) {
            LOGGER.correlateWith(context).debug("Sending message via the event bus to {}", qualifiedName);
            String address = DataVerticle.getAddress(qualifiedName);
            return vertx.eventBus().request(address, (Object)request.getQuery(), DataVerticle.requestDeliveryOptions(vertx, request, context, address)).transform(asyncReply -> {
                LOGGER.correlateWith(context).debug("Received event bus reply");
                if (asyncReply.succeeded()) {
                    Object body = ((Message)asyncReply.result()).body();
                    if (body instanceof DataException) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.correlateWith(context).warn("Received a event bus reply failure from {}", qualifiedName, (DataException)body);
                        }
                        return Future.failedFuture((Throwable)((DataException)body));
                    }
                    DataContext responseDataContext = DataContextImpl.decodeContextFromString(((Message)asyncReply.result()).headers().get(CONTEXT_HEADER));
                    context.setData(Optional.ofNullable(responseDataContext).map(DataContext::data).orElse(null));
                    context.mergeResponseData(Optional.ofNullable(responseDataContext).map(DataContext::responseData).orElse(null));
                    return Future.succeededFuture((Object)((Message)asyncReply.result()).body());
                }
                Throwable cause = asyncReply.cause();
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.correlateWith(context).warn("Failed to receive event bus reply from {}", qualifiedName, cause);
                }
                return Future.failedFuture((Throwable)DataVerticle.mapException(cause));
            });
        }
        FullQualifiedName entityTypeName = request.getEntityTypeName();
        if (entityTypeName != null) {
            return EntityVerticle.requestEntity(vertx, request, context).map(FunctionalHelper::uncheckedMapper);
        }
        return Future.failedFuture((Throwable)new IllegalArgumentException("Data request did not specify what data to request"));
    }

    public <U> Future<U> requestData(DataRequest request, DataContext context) {
        LOGGER.correlateWith(context).debug("Data verticle {} requesting data from {}", this.getQualifiedName(), request);
        Future<U> future = DataVerticle.requestData(this.vertx, request, context);
        this.reportRequestDataMetrics(request, future);
        return future;
    }

    public static String createQualifiedName(String namespace, String verticleName) {
        return String.format("%s/%s", namespace.toLowerCase(Locale.ROOT), verticleName);
    }

    protected final String getAddress() {
        return DataVerticle.getAddress(this.getQualifiedName());
    }

    protected static String getAddress(String qualifiedName) {
        return String.format("%s[%s]", DataVerticle.class.getSimpleName(), qualifiedName);
    }

    private static DeliveryOptions requestDeliveryOptions(Vertx vertx, DataRequest request, DataContext context, String address) {
        if (context instanceof DataContextImpl) {
            ((DataContextImpl)context).pushVerticleToPath(request.getQualifiedName());
        }
        DeliveryOptions deliveryOptions = DataVerticle.deliveryOptions(vertx, null, context);
        if (context instanceof DataContextImpl) {
            ((DataContextImpl)context).popVerticleFromPath();
        }
        boolean localOnly = request.isLocalOnly() || request.isLocalPreferred() && NeonBee.get(vertx).isLocalConsumerAvailable(address);
        deliveryOptions.setLocalOnly(localOnly);
        if (request.getSendTimeout() > 0L) {
            deliveryOptions.setSendTimeout(request.getSendTimeout());
        }
        Optional.ofNullable(request.getResolutionStrategy()).map(Enum::name).ifPresent(value -> deliveryOptions.addHeader(RESOLUTION_STRATEGY_HEADER, value));
        return deliveryOptions;
    }

    private static DeliveryOptions deliveryOptions(Vertx vertx, MessageCodec<?, ?> codec, DataContext context) {
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setSendTimeout(TimeUnit.SECONDS.toMillis(NeonBee.get(vertx).getConfig().getEventBusTimeout())).setCodecName((String)Optional.ofNullable(codec).map(MessageCodec::name).orElse(null));
        Optional.ofNullable(context).map(DataContextImpl::encodeContextToString).ifPresent(value -> deliveryOptions.addHeader(CONTEXT_HEADER, value));
        return deliveryOptions;
    }

    private static DataException mapException(Throwable cause) {
        if (cause instanceof DataException) {
            return (DataException)cause;
        }
        int failureCode = 1030;
        String message = cause.getMessage();
        if (cause instanceof ReplyException) {
            ReplyException replyException = (ReplyException)cause;
            switch (replyException.failureType()) {
                case NO_HANDLERS: {
                    failureCode = 1010;
                    break;
                }
                case TIMEOUT: {
                    failureCode = 1020;
                    break;
                }
                default: {
                    failureCode = replyException.failureCode();
                }
            }
        }
        return new DataException(failureCode, message);
    }

    public abstract String getName();

    public final String getNamespace() {
        return this.namespaceSupplier.get();
    }

    public MessageCodec<T, T> getMessageCodec() {
        return null;
    }

    public void init(Vertx vertx, Context context) {
        block3: {
            super.init(vertx, context);
            JsonObject metrics = this.getMetricsConfig(NeonBee.get(vertx).getConfig().getMetricsConfig());
            this.dataVerticleMetrics = ConfiguredDataVerticleMetrics.configureMetricsReporting(NeonBee.get(vertx), metrics);
            MessageCodec<T, T> codec = this.getMessageCodec();
            if (codec != null && codec.name() != null) {
                try {
                    vertx.eventBus().registerCodec(codec);
                }
                catch (IllegalStateException e) {
                    if (!LOGGER.isDebugEnabled() || !e.getMessage().startsWith("Already a codec registered with name")) break block3;
                    LOGGER.debug("Codec {} is already registered. Ignore the exception.", codec.name());
                }
            }
        }
    }

    @VisibleForTesting
    JsonObject getMetricsConfig(MetricsConfig globalMetricsConfig) {
        MetricsConfig metricsConfig = globalMetricsConfig == null ? new MetricsConfig().setEnabled(false) : globalMetricsConfig;
        JsonObject verticleMetricsConfig = this.config() == null ? new JsonObject() : this.config().getJsonObject(CONFIG_METRICS_KEY, new JsonObject());
        Boolean enabled = verticleMetricsConfig.getBoolean("enabled");
        if (enabled == null || Boolean.TRUE.equals(enabled)) {
            verticleMetricsConfig.put("enabled", (Object)metricsConfig.isEnabled());
        }
        return verticleMetricsConfig;
    }

    public void start(Promise<Void> promise) {
        Promise registerDataVerticlePromise = Promise.promise();
        String address = this.getAddress();
        this.vertx.eventBus().consumer(address, message -> {
            ManipulationRoutine routine;
            MultiMap headers = message.headers();
            try {
                routine = ((DataQuery)message.body()).getAction() == DataAction.READ ? this.resolutionRoutineForStrategy(Optional.ofNullable(headers.get(RESOLUTION_STRATEGY_HEADER)).map(DataRequest.ResolutionStrategy::valueOf).orElse(DataRequest.ResolutionStrategy.RECURSIVE)) : new ManipulationRoutine();
            }
            catch (IllegalArgumentException e) {
                message.fail(1000, "Unknown data resolution strategy");
                return;
            }
            DataContext context = DataContextImpl.decodeContextFromString(headers.get(CONTEXT_HEADER));
            if (context instanceof DataContextImpl) {
                ((DataContextImpl)context).amendTopVerticleCoordinate(this.deploymentID());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.correlateWith(context).debug("Data verticle {} received event bus message from {}, using resolution routine {}", new Object[]{this.getQualifiedName(), message.replyAddress(), routine.getClass().getSimpleName()});
            }
            try {
                routine.execute((DataQuery)message.body(), context).onComplete(asyncResult -> {
                    try {
                        if (asyncResult.succeeded()) {
                            message.reply(asyncResult.result(), DataVerticle.deliveryOptions(this.vertx, this.getMessageCodec(), context));
                        } else {
                            Throwable cause = asyncResult.cause();
                            if (LOGGER.isWarnEnabled()) {
                                LOGGER.correlateWith(context).warn("Data verticle {} routine execution failed", new Object[]{this.getQualifiedName(), cause instanceof DataException ? cause.toString() : "", cause});
                            }
                            if (cause instanceof DataException) {
                                message.reply((Object)cause);
                            } else {
                                message.fail(1030, "Processing of message failed. " + cause.getMessage());
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.correlateWith(context).error("Processing of message failed", e);
                        message.fail(1030, e.getMessage());
                    }
                });
            }
            catch (IllegalArgumentException e) {
                LOGGER.correlateWith(context).error("Missing message codec", e);
                message.fail(1001, e.getMessage());
            }
            catch (DataException e) {
                LOGGER.correlateWith(context).error("Processing of message failed", e);
                message.fail(e.failureCode(), e.getMessage());
            }
        }).completionHandler((Handler)registerDataVerticlePromise);
        registerDataVerticlePromise.future().compose(v -> {
            try {
                this.start();
                NeonBee.get(this.vertx).registerLocalConsumer(address);
                return Future.succeededFuture((Object)null);
            }
            catch (Exception e) {
                return Future.failedFuture((Throwable)e);
            }
        }).onComplete(promise);
    }

    public void stop() throws Exception {
        NeonBee neonBee = NeonBee.get(this.vertx);
        if (neonBee != null) {
            neonBee.unregisterLocalConsumer(this.getAddress());
        }
        super.stop();
    }

    public Future<Collection<DataRequest>> requireData(DataQuery query, DataContext context) {
        return Future.succeededFuture(Collections.emptyList());
    }

    public Future<T> retrieveData(DataQuery query, DataMap require, DataContext context) {
        return this.retrieveData(query, context);
    }

    private <U> void reportRequestDataMetrics(DataRequest request, Future<U> future) {
        List<Object> tags = request.getQuery() == null || request.getQuery().getQuery() == null ? List.of() : List.of(new ImmutableTag("query", request.getQuery().getQuery()));
        String qualifiedName = request.getQualifiedName();
        this.dataVerticleMetrics.reportTimingMetric("request.data.timer." + qualifiedName, "time to retrieve the data", tags, future);
        this.dataVerticleMetrics.reportStatusCounter("request.data.counter." + qualifiedName, SUCCEEDED_RESPONSE_COUNT, tags, future);
        this.dataVerticleMetrics.reportActiveRequestsGauge("request.data.active.requests." + qualifiedName, "Number of requests waiting for a response", List.of(), future);
        this.dataVerticleMetrics.reportNumberOfRequests("request.counter." + qualifiedName, "Number of requests sent", tags);
    }

    @VisibleForTesting
    public final String getQualifiedName() {
        String name = this.getName();
        String namespace = this.getNamespace();
        return namespace != null ? DataVerticle.createQualifiedName(namespace, name) : name;
    }

    private ResolutionRoutine resolutionRoutineForStrategy(DataRequest.ResolutionStrategy strategy) {
        if (strategy == DataRequest.ResolutionStrategy.OPTIMIZED) {
            return new OptimizedResolutionRoutine();
        }
        return new RecursiveResolutionRoutine();
    }

    private class OptimizedResolutionRoutine
    implements ResolutionRoutine {
        private OptimizedResolutionRoutine() {
        }

        public Future<T> execute(DataQuery query, DataContext context) {
            return Future.failedFuture((Throwable)new UnsupportedOperationException("Optimized resolution strategy not available."));
        }
    }

    private class RecursiveResolutionRoutine
    implements ResolutionRoutine {
        private RecursiveResolutionRoutine() {
        }

        public Future<T> execute(DataQuery query, DataContext context) {
            LinkedHashMap requestResults = new LinkedHashMap();
            LinkedHashMap receivedDataContextMap = new LinkedHashMap();
            return DataVerticle.this.requireData(query, context).compose(requests -> CompositeFuture.join(Optional.ofNullable(requests).map(Collection::stream).orElse(Stream.empty()).map(request -> {
                DataContext requestContext = context.copy();
                receivedDataContextMap.put(request, requestContext);
                return requestResults.computeIfAbsent(request, mapRequest -> {
                    Future future = DataVerticle.requestData(DataVerticle.this.vertx, request, requestContext);
                    DataVerticle.this.reportRequestDataMetrics((DataRequest)request, future);
                    return future;
                });
            }).map(Future.class::cast).collect(Collectors.toList())).otherwiseEmpty()).compose(requiredCompositeOrNothing -> {
                List<Tag> tags = this.retrieveDataTags();
                try {
                    Map<DataRequest, Map<String, Object>> receivedData = receivedDataContextMap.entrySet().stream().map(entry -> Map.entry((DataRequest)entry.getKey(), ((DataContext)entry.getValue()).responseData())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    context.setReceivedData(receivedData);
                    Future future = DataVerticle.this.retrieveData(query, new DataMap(requestResults), context);
                    this.reportRetrieveDataMetrics(tags, future);
                    return future;
                }
                catch (Exception e) {
                    DataVerticle.this.dataVerticleMetrics.reportStatusCounter("retrieve.data.counter." + DataVerticle.this.getAddress(), DataVerticle.SUCCEEDED_RESPONSE_COUNT, tags, Future.failedFuture((Throwable)e));
                    return Future.failedFuture((Throwable)e);
                }
            });
        }

        private List<Tag> retrieveDataTags() {
            String namespace;
            ArrayList<Tag> tags = new ArrayList<Tag>(2);
            String name = DataVerticle.this.getName();
            if (name != null) {
                tags.add((Tag)new ImmutableTag("name", name));
            }
            if ((namespace = DataVerticle.this.getNamespace()) != null) {
                tags.add((Tag)new ImmutableTag("namespace", namespace));
            }
            return tags;
        }

        private void reportRetrieveDataMetrics(List<Tag> tags, Future<T> future) {
            String address = DataVerticle.this.getAddress();
            DataVerticle.this.dataVerticleMetrics.reportTimingMetric("retrieve.data.timer." + address, "Time to retrieve data", tags, future);
            DataVerticle.this.dataVerticleMetrics.reportStatusCounter("retrieve.data.counter." + address, DataVerticle.SUCCEEDED_RESPONSE_COUNT, tags, future);
            DataVerticle.this.dataVerticleMetrics.reportActiveRequestsGauge("retrieve.data.active.requests." + address, "Number of requests waiting for a response", tags, future);
            DataVerticle.this.dataVerticleMetrics.reportNumberOfRequests("retrieve.counter." + address, "Number of requests sent", tags);
        }
    }

    private static interface ResolutionRoutine {
        public Future<?> execute(DataQuery var1, DataContext var2);
    }

    private class ManipulationRoutine
    implements ResolutionRoutine {
        private ManipulationRoutine() {
        }

        public Future<T> execute(DataQuery query, DataContext context) {
            try {
                return DataVerticle.this.manipulateData(query, context);
            }
            catch (Exception e) {
                return Future.failedFuture((Throwable)e);
            }
        }
    }
}

