/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataException;
import io.neonbee.data.DataRequest;
import io.neonbee.data.internal.DataVerticleCoordinateImpl;
import io.neonbee.internal.handler.CorrelationIdHandler;
import io.neonbee.internal.helper.CollectionHelper;
import io.neonbee.internal.helper.HostHelper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataContextImpl
implements DataContext {
    @VisibleForTesting
    static final String NO_SESSION_ID_AVAILABLE_KEY = "noSessionIdAvailable";
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final String USER_PRINCIPAL_KEY = "userPrincipal";
    private static final String BEARER_TOKEN_KEY = "bearerToken";
    private static final String DATA_KEY = "data";
    private static final String PATH_KEY = "path";
    private static final String SESSION_ID_KEY = "sessionId";
    private static final Pattern BEARER_AUTHENTICATION_PATTERN = Pattern.compile("Bearer\\s(.+)");
    private static final String RESPONSE_METADATA_KEY = "responsedata";
    private final String correlationId;
    private final String bearerToken;
    private final JsonObject userPrincipal;
    private final String sessionId;
    private Map<String, Object> data;
    private Map<String, Object> responseData;
    private Deque<DataContext.DataVerticleCoordinate> pathStack;
    private Map<DataRequest, Map<String, Object>> receivedData;

    public DataContextImpl() {
        this(null, null, null, null, null, null);
    }

    public DataContextImpl(RoutingContext routingContext) {
        this(CorrelationIdHandler.getCorrelationId(routingContext), Optional.ofNullable(routingContext.session()).map(Session::id).orElse(NO_SESSION_ID_AVAILABLE_KEY), Optional.ofNullable(routingContext.request().getHeader(HttpHeaders.AUTHORIZATION)).map(BEARER_AUTHENTICATION_PATTERN::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1)).orElse(null), Optional.ofNullable(routingContext.user()).map(User::principal).orElse(null), null, null);
    }

    @Deprecated
    public DataContextImpl(String correlationId, JsonObject userPrincipal) {
        this(correlationId, null, null, userPrincipal, null, null);
    }

    public DataContextImpl(String correlationId, String sessionId, JsonObject userPrincipal) {
        this(correlationId, sessionId, null, userPrincipal, null, null);
    }

    @Deprecated
    public DataContextImpl(String correlationId, String bearerToken, JsonObject userPrincipal, Map<String, Object> data) {
        this(correlationId, null, bearerToken, userPrincipal, data, null);
    }

    public DataContextImpl(String correlationId, String sessionId, String bearerToken, JsonObject userPrincipal, Map<String, Object> data) {
        this(correlationId, sessionId, bearerToken, userPrincipal, data, null);
    }

    @Deprecated
    public DataContextImpl(String correlationId, String bearerToken, JsonObject userPrincipal, Map<String, Object> data, Deque<DataContext.DataVerticleCoordinate> paths) {
        this(correlationId, null, bearerToken, userPrincipal, data, paths);
    }

    public DataContextImpl(String correlationId, String sessionId, String bearerToken, JsonObject userPrincipal, Map<String, Object> data, Deque<DataContext.DataVerticleCoordinate> paths) {
        this(correlationId, sessionId, bearerToken, userPrincipal, data, null, paths);
    }

    public DataContextImpl(String correlationId, String sessionId, String bearerToken, JsonObject userPrincipal, Map<String, Object> data, Map<String, Object> responseData, Deque<DataContext.DataVerticleCoordinate> paths) {
        this.correlationId = correlationId;
        this.sessionId = sessionId;
        this.bearerToken = bearerToken;
        this.userPrincipal = Optional.ofNullable(userPrincipal).map(JsonObject::getMap).map(Collections::unmodifiableMap).map(JsonObject::new).orElse(null);
        this.setData(data);
        this.responseData = CollectionHelper.mutableCopyOf(responseData);
        this.setPath(paths);
    }

    @VisibleForTesting
    protected DataContextImpl(DataContext original) {
        this.correlationId = original.correlationId();
        this.sessionId = original.sessionId();
        this.bearerToken = original.bearerToken();
        this.userPrincipal = original.userPrincipal();
        this.setData(original.data());
        this.setPath(original.path());
    }

    @Override
    public String correlationId() {
        return this.correlationId;
    }

    @Override
    public String bearerToken() {
        return this.bearerToken;
    }

    @Override
    public JsonObject userPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public Map<String, Object> data() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    @VisibleForTesting
    protected void setPath(Iterator<DataContext.DataVerticleCoordinate> path) {
        this.pathStack = DataContextImpl.streamPath(path).collect(Collector.of(ArrayDeque::new, (deq, t) -> deq.addFirst(t), (d1, d2) -> {
            d2.addAll(d1);
            return d2;
        }, new Collector.Characteristics[0]));
    }

    @VisibleForTesting
    protected DataContext setPath(Deque<DataContext.DataVerticleCoordinate> path) {
        this.pathStack = CollectionHelper.mutableCopyOf(path, ArrayDeque::new);
        return this;
    }

    @Override
    public final DataContext setData(Map<String, Object> data) {
        this.data = data != null && !data.isEmpty() ? CollectionHelper.mutableCopyOf(data) : null;
        return this;
    }

    @Override
    public DataContext mergeData(Map<String, Object> data) {
        if (data != null && !data.isEmpty()) {
            this.data.putAll(CollectionHelper.mutableCopyOf(data));
        }
        return this;
    }

    @Override
    public DataContext put(String key, Object value) {
        this.data().put(key, value);
        return this;
    }

    @Override
    public <T> T get(String key) {
        Object value = this.data().get(key);
        if (value instanceof Map) {
            value = new JsonObject((Map)value);
        } else if (value instanceof List) {
            value = new JsonArray((List)value);
        }
        return (T)value;
    }

    @Override
    public <T> T remove(String key) {
        Object value = this.data().remove(key);
        if (value instanceof Map) {
            value = new JsonObject((Map)value);
        } else if (value instanceof List) {
            value = new JsonArray((List)value);
        }
        return (T)value;
    }

    @Override
    public Map<String, Object> responseData() {
        if (this.responseData == null) {
            this.responseData = new HashMap<String, Object>();
        }
        return this.responseData;
    }

    @Override
    public DataContext mergeResponseData(Map<String, Object> data) {
        if (!CollectionHelper.isNullOrEmpty(data)) {
            this.responseData().putAll(CollectionHelper.mutableCopyOf(data));
        }
        return this;
    }

    @Override
    public Map<DataRequest, Map<String, Object>> receivedData() {
        return this.receivedData;
    }

    @Override
    public DataContext setReceivedData(Map<DataRequest, Map<String, Object>> map) {
        this.receivedData = Collections.unmodifiableMap(map);
        return this;
    }

    @Override
    public Map<String, Object> findReceivedData(DataRequest dataRequest) {
        return this.receivedData.getOrDefault(dataRequest, Map.of());
    }

    @Override
    public Optional<Map<String, Object>> findFirstReceivedData(String qualifiedName) {
        return this.receivedData.entrySet().stream().filter(entry -> qualifiedName.equals(((DataRequest)entry.getKey()).getQualifiedName())).findFirst().map(Map.Entry::getValue);
    }

    @Override
    public List<Map<String, Object>> findAllReceivedData(String qualifiedName) {
        return this.receivedData.entrySet().stream().filter(entry -> qualifiedName.equals(((DataRequest)entry.getKey()).getQualifiedName())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public void propagateReceivedData() {
        this.receivedData.values().stream().forEach(data -> this.mergeResponseData((Map<String, Object>)data));
    }

    public static String encodeContextToString(DataContext context) {
        if (context == null) {
            return null;
        }
        return new JsonObject().put("correlationId", (Object)context.correlationId()).put(SESSION_ID_KEY, (Object)context.sessionId()).put(BEARER_TOKEN_KEY, (Object)context.bearerToken()).put(USER_PRINCIPAL_KEY, (Object)context.userPrincipal()).put(DATA_KEY, (Object)new JsonObject(context.data())).put(RESPONSE_METADATA_KEY, (Object)new JsonObject(context.responseData())).put(PATH_KEY, (Object)DataContextImpl.pathToJson(context.path())).toString();
    }

    private static JsonArray pathToJson(Iterator<DataContext.DataVerticleCoordinate> path) {
        return new JsonArray(DataContextImpl.streamPath(path).map(JsonObject::mapFrom).collect(Collectors.toList()));
    }

    public static DataContext decodeContextFromString(String contextString) {
        if (contextString == null) {
            return null;
        }
        JsonObject contextJson = new JsonObject(contextString);
        return new DataContextImpl(contextJson.getString("correlationId"), contextJson.getString(SESSION_ID_KEY), contextJson.getString(BEARER_TOKEN_KEY), contextJson.getJsonObject(USER_PRINCIPAL_KEY), Optional.ofNullable(contextJson.getJsonObject(DATA_KEY)).map(JsonObject::getMap).orElse(null), Optional.ofNullable(contextJson.getJsonObject(RESPONSE_METADATA_KEY)).map(JsonObject::getMap).orElse(null), Optional.ofNullable(contextJson.getJsonArray(PATH_KEY)).map(DataContextImpl::pathFromJson).orElse(null));
    }

    private static Deque<DataContext.DataVerticleCoordinate> pathFromJson(JsonArray array) {
        return array.stream().map(JsonObject.class::cast).map(object -> (DataVerticleCoordinateImpl)object.mapTo(DataVerticleCoordinateImpl.class)).collect(ArrayDeque::new, Deque::push, Deque::addAll);
    }

    public void pushVerticleToPath(String name) {
        DataContext.DataVerticleCoordinate topVerticle;
        if (!this.pathStack.isEmpty() && name.equalsIgnoreCase((topVerticle = this.pathStack.peek()).getQualifiedName())) {
            LOGGER.error("A DataVerticle {} is sending message to itself, which could lead to a dead loop", name);
            throw new DataException(String.format("DataVerticle %s is sending message to itself.", name));
        }
        this.pathStack.push(new DataVerticleCoordinateImpl(name));
    }

    public DataContext amendTopVerticleCoordinate(String deploymentId) {
        Optional.ofNullable(this.pathStack.peek()).map(DataVerticleCoordinateImpl.class::cast).ifPresent(coordinate -> {
            coordinate.setDeploymentId(deploymentId);
            coordinate.setIpAddress(HostHelper.getHostIp());
        });
        return this;
    }

    public void popVerticleFromPath() {
        this.pathStack.pop();
    }

    @Override
    public Iterator<DataContext.DataVerticleCoordinate> path() {
        return Iterators.unmodifiableIterator(this.pathStack.descendingIterator());
    }

    @Override
    public String pathAsString() {
        return DataContextImpl.streamPath(this.path()).map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    static Stream<DataContext.DataVerticleCoordinate> streamPath(Iterator<DataContext.DataVerticleCoordinate> path) {
        return Optional.ofNullable(path).map(Streams::stream).orElseGet(Stream::empty);
    }

    @Override
    public DataContextImpl copy() {
        return new DataContextImpl(this);
    }

    @Override
    public void updateResponseTimestamp() {
        Optional.ofNullable(this.pathStack.peek()).map(DataVerticleCoordinateImpl.class::cast).ifPresent(DataVerticleCoordinateImpl::updateResponseTimestamp);
    }
}

