/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import io.neonbee.NeonBee;
import io.neonbee.config.EndpointConfig;
import io.neonbee.endpoint.Endpoint;
import io.neonbee.endpoint.odatav4.internal.olingo.OlingoEndpointHandler;
import io.neonbee.entity.EntityModel;
import io.neonbee.entity.EntityModelManager;
import io.neonbee.internal.RegexBlockList;
import io.neonbee.internal.SharedDataAccessor;
import io.neonbee.internal.helper.FunctionalHelper;
import io.neonbee.logging.LoggingFacade;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Lock;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.apache.olingo.server.api.ServiceMetadata;

public class ODataV4Endpoint
implements Endpoint {
    public static final String CONFIG_URI_CONVERSION = "uriConversion";
    public static final String DEFAULT_BASE_PATH = "/odata/";
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final String NORMALIZED_URI_CONTEXT_KEY = ODataV4Endpoint.class.getName() + "_normalizedUri";

    @Override
    public EndpointConfig getDefaultConfig() {
        return new EndpointConfig().setType(ODataV4Endpoint.class.getName()).setBasePath(DEFAULT_BASE_PATH).setAdditionalConfig(new JsonObject().put(CONFIG_URI_CONVERSION, (Object)UriConversion.STRICT.name()));
    }

    @Override
    public Future<Router> createEndpointRouter(Vertx vertx, String basePath, JsonObject config) {
        Router router = Router.router((Vertx)vertx);
        AtomicBoolean initialized = new AtomicBoolean();
        AtomicReference models = new AtomicReference();
        UriConversion uriConversion = UriConversion.byName(config.getString(CONFIG_URI_CONVERSION, UriConversion.STRICT.name()));
        RegexBlockList exposedEntities = RegexBlockList.fromJson(config.getValue("exposedEntities"));
        vertx.eventBus().consumer(EntityModelManager.EVENT_BUS_MODELS_LOADED_ADDRESS, message -> {
            if (initialized.get()) {
                ODataV4Endpoint.refreshRouter(vertx, router, basePath, uriConversion, exposedEntities, models);
            }
        });
        Route initialRoute = router.route();
        initialRoute.handler(routingContext -> new SharedDataAccessor(vertx, ODataV4Endpoint.class).getLocalLock((Handler<AsyncResult<Lock>>)((Handler)asyncLock -> (!initialized.getAndSet(true) ? ODataV4Endpoint.refreshRouter(vertx, router, basePath, uriConversion, exposedEntities, models) : Future.succeededFuture()).onComplete(handler -> {
            initialRoute.remove();
            if (asyncLock.succeeded()) {
                ((Lock)asyncLock.result()).release();
            }
            routingContext.reroute(routingContext.request().uri());
        }))));
        return Future.succeededFuture((Object)router);
    }

    private static Future<Void> refreshRouter(Vertx vertx, Router router, String basePath, UriConversion uriConversion, RegexBlockList exposedEntities, AtomicReference<Map<String, EntityModel>> currentModels) {
        return NeonBee.get(vertx).getModelManager().getSharedModels().compose(models -> {
            if (models == currentModels.get()) {
                return Future.succeededFuture();
            }
            currentModels.set((Map<String, EntityModel>)models);
            List existingRoutes = router.getRoutes();
            models.values().stream().flatMap(entityModel -> entityModel.getAllEdmxMetadata().entrySet().stream()).map(FunctionalHelper.entryFunction((schemaNamespace, edmxModel) -> Map.entry(uriConversion.apply((String)schemaNamespace), edmxModel))).sorted(Map.Entry.comparingByKey(Comparator.comparingInt(String::length).reversed())).forEach(FunctionalHelper.entryConsumer((uriPath, edmxModel) -> {
                String schemaNamespace = edmxModel.getEdm().getEntityContainer().getNamespace();
                router.route((String)(uriPath.isEmpty() ? "" : "/" + uriPath) + "/*").handler(routingContext -> {
                    NormalizedUri normalizedUri = ODataV4Endpoint.normalizeUri(routingContext, schemaNamespace);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.correlateWith((RoutingContext)routingContext).debug("Normalized OData V4 URI {}", normalizedUri);
                    }
                    if (normalizedUri.fullQualifiedName != null && !exposedEntities.isAllowed(normalizedUri.fullQualifiedName)) {
                        routingContext.fail(HttpResponseStatus.FORBIDDEN.code());
                        return;
                    }
                    routingContext.next();
                }).handler((Handler)new OlingoEndpointHandler((ServiceMetadata)edmxModel));
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Serving OData service endpoint for {} at {}{} ({} URI mapping)", new Object[]{schemaNamespace, basePath, uriPath, uriConversion.name().toLowerCase(Locale.getDefault())});
                }
            }));
            existingRoutes.forEach(Route::remove);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Refreshed OData endpoint router, populated {} models, removed {} existing routes", models.size(), existingRoutes.size());
            }
            return Future.succeededFuture();
        });
    }

    public static NormalizedUri normalizeUri(RoutingContext routingContext, String schemaNamespace) {
        return Optional.ofNullable((NormalizedUri)routingContext.get(NORMALIZED_URI_CONTEXT_KEY)).orElseGet(() -> {
            NormalizedUri normalizedUri = new NormalizedUri(routingContext, schemaNamespace);
            routingContext.put(NORMALIZED_URI_CONTEXT_KEY, (Object)normalizedUri);
            return normalizedUri;
        });
    }

    public static enum UriConversion implements UnaryOperator<String>
    {
        STRICT(uriPart -> uriPart),
        CDS(uriPart -> {
            uriPart = uriPart.substring(uriPart.lastIndexOf(46) + 1);
            uriPart = uriPart.replaceFirst("Service$", "");
            uriPart = Pattern.compile("^[A-Z]+").matcher((CharSequence)uriPart).replaceFirst(match -> match.group().toLowerCase(Locale.ROOT));
            uriPart = Pattern.compile("[A-Z]+[a-z0-9]").matcher((CharSequence)uriPart).replaceAll(match -> "-" + match.group().toLowerCase(Locale.ROOT));
            uriPart = uriPart.toLowerCase(Locale.ROOT);
            uriPart = uriPart.replace('_', '-');
            return uriPart;
        }),
        LOOSE(uriPart -> {
            uriPart = CDS.apply(((String)uriPart).substring(0, ((String)uriPart).lastIndexOf(46) + 1).replace('.', '-')) + CDS.apply((String)uriPart);
            uriPart = ((String)uriPart).replaceFirst("-$", "");
            return uriPart;
        });

        final UnaryOperator<String> convert;

        private UriConversion(UnaryOperator<String> convert) {
            this.convert = convert;
        }

        @Override
        public String apply(String uriPart) {
            if (Strings.isNullOrEmpty((String)uriPart)) {
                return "";
            }
            return (String)this.convert.apply(uriPart);
        }

        public static UriConversion byName(String name) {
            switch (Strings.nullToEmpty((String)name).toLowerCase(Locale.ROOT)) {
                case "strict": {
                    return STRICT;
                }
                case "loose": {
                    return LOOSE;
                }
                case "cds": {
                    return CDS;
                }
            }
            LOGGER.warn("Unknown URI conversion {} falling back to \"strict\" mapping", name);
            return STRICT;
        }
    }

    public static class NormalizedUri {
        public final String requestUri;
        public final String requestPath;
        public final String requestQuery;
        public final String baseUri;
        public final String basePath;
        public final String schemaNamespace;
        public final String resourcePath;
        public final String entityName;
        public final String fullQualifiedName;

        private NormalizedUri(RoutingContext routingContext, String schemaNamespace) {
            this.schemaNamespace = schemaNamespace;
            Route route = routingContext.currentRoute();
            String routeMountPoint = routingContext.mountPoint();
            String routePath = Optional.ofNullable(route).map(Route::getPath).orElse("").replaceAll("/+$", "") + "/";
            HttpServerRequest request = routingContext.request();
            Object requestPath = request.path();
            if (!((String)requestPath).contains(routePath)) {
                requestPath = (String)requestPath + "/";
            }
            String hostUri = request.scheme() + "://" + request.host();
            this.basePath = routeMountPoint;
            this.baseUri = hostUri + this.basePath;
            this.resourcePath = ((String)requestPath).substring((routeMountPoint + routePath).replaceAll("/{2,}", "/").length() - 1);
            this.entityName = Strings.emptyToNull((String)this.resourcePath.split("\\W", 2)[0]);
            this.fullQualifiedName = this.entityName != null ? schemaNamespace + "." + this.entityName : null;
            this.requestQuery = URLDecoder.decode(Strings.nullToEmpty((String)request.query()), StandardCharsets.UTF_8);
            this.requestPath = this.basePath + schemaNamespace + this.resourcePath;
            this.requestUri = hostUri + (String)this.requestPath + (String)(this.requestQuery.isEmpty() ? "" : "?" + this.requestQuery);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("requestUri", (Object)this.requestUri).add("requestPath", (Object)this.requestPath).add("requestQuery", (Object)this.requestQuery).add("baseUri", (Object)this.baseUri).add("basePath", (Object)this.basePath).add("schemaNamespace", (Object)this.schemaNamespace).add("resourcePath", (Object)this.resourcePath).add("entityName", (Object)this.entityName).add("fullQualifiedName", (Object)this.fullQualifiedName).toString();
        }
    }
}

