/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.expression;

import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmHelper;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operands.ExpressionVisitorOperand;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operators.BinaryOperator;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operators.DateFunctionMethodCallOperator;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operators.StringFunctionMethodCallOperator;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operators.UnaryOperator;
import io.neonbee.logging.LoggingFacade;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Optional;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;

public class FilterExpressionVisitor
implements ExpressionVisitor<ExpressionVisitorOperand> {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private final RoutingContext routingContext;
    private final Entity entity;

    public FilterExpressionVisitor(RoutingContext routingContext, Entity entity) {
        this.routingContext = routingContext;
        this.entity = entity;
    }

    public ExpressionVisitorOperand visitBinaryOperator(BinaryOperatorKind operator, ExpressionVisitorOperand left, List<ExpressionVisitorOperand> right) throws ExpressionVisitException, ODataApplicationException {
        if (BinaryOperatorKind.IN.equals((Object)operator)) {
            return new BinaryOperator(this.routingContext, left, right).inOperator();
        }
        return EdmHelper.throwNotImplementedODataException();
    }

    public ExpressionVisitorOperand visitBinaryOperator(BinaryOperatorKind operator, ExpressionVisitorOperand left, ExpressionVisitorOperand right) throws ExpressionVisitException, ODataApplicationException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.correlateWith(this.routingContext).trace("Operator: {}", operator);
        }
        BinaryOperator binaryOperator = new BinaryOperator(this.routingContext, left, right);
        switch (operator) {
            case AND: {
                return binaryOperator.andOperator();
            }
            case OR: {
                return binaryOperator.orOperator();
            }
            case EQ: {
                return binaryOperator.equalsOperator();
            }
            case NE: {
                return binaryOperator.notEqualsOperator();
            }
            case GE: {
                return binaryOperator.greaterEqualsOperator();
            }
            case GT: {
                return binaryOperator.greaterThanOperator();
            }
            case LE: {
                return binaryOperator.lessEqualsOperator();
            }
            case LT: {
                return binaryOperator.lessThanOperator();
            }
            case IN: {
                return binaryOperator.inOperator();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.correlateWith(this.routingContext).debug("Operator '{}' is not yet implemented.", operator);
        }
        return EdmHelper.throwNotImplementedODataException();
    }

    public ExpressionVisitorOperand visitLiteral(Literal literal) throws ExpressionVisitException, ODataApplicationException {
        String literalText = EdmHelper.extractValueFromLiteral(literal.getText());
        EdmType literalType = literal.getType();
        if (LOGGER.correlateWith(this.routingContext).isTraceEnabled()) {
            LOGGER.correlateWith(this.routingContext).trace("literal type: {}, literal text: {}", literalType, literalText);
        }
        return new ExpressionVisitorOperand(this.routingContext, literalText, literalType);
    }

    public ExpressionVisitorOperand visitUnaryOperator(UnaryOperatorKind operator, ExpressionVisitorOperand operand) throws ExpressionVisitException, ODataApplicationException {
        UnaryOperator unaryOperator = new UnaryOperator(this.routingContext, operand);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.correlateWith(this.routingContext).trace("Unary Operator: {}", unaryOperator);
        }
        if (UnaryOperatorKind.NOT.equals((Object)operator)) {
            return unaryOperator.notOperation();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.correlateWith(this.routingContext).debug("Unary Operator '{}' is not yet implemented.", unaryOperator);
        }
        return EdmHelper.throwNotImplementedODataException();
    }

    public ExpressionVisitorOperand visitMember(Member member) throws ExpressionVisitException, ODataApplicationException {
        List uriResourceParts = member.getResourcePath().getUriResourceParts();
        UriResource initialPart = (UriResource)uriResourceParts.get(0);
        if (initialPart instanceof UriResourceProperty) {
            UriResourceProperty uriResourceProperty = Optional.ofNullable((UriResourceProperty)initialPart).orElseThrow();
            EdmProperty edmProperty = Optional.ofNullable(uriResourceProperty.getProperty()).orElseThrow();
            Property property = Optional.ofNullable(this.entity.getProperty(edmProperty.getName())).orElseThrow();
            if (property.isPrimitive()) {
                return new ExpressionVisitorOperand(this.routingContext, property.getValue(), edmProperty.getType(), edmProperty);
            }
            return EdmHelper.throwNotImplementedODataException();
        }
        return EdmHelper.throwNotImplementedODataException();
    }

    public ExpressionVisitorOperand visitMethodCall(MethodKind methodCall, List<ExpressionVisitorOperand> parameters) throws ExpressionVisitException, ODataApplicationException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.correlateWith(this.routingContext).trace("Method Call: {}", methodCall);
        }
        switch (methodCall) {
            case ENDSWITH: {
                return new StringFunctionMethodCallOperator(this.routingContext, parameters).endsWith();
            }
            case INDEXOF: {
                return new StringFunctionMethodCallOperator(this.routingContext, parameters).indexOf();
            }
            case STARTSWITH: {
                return new StringFunctionMethodCallOperator(this.routingContext, parameters).startsWith();
            }
            case TOLOWER: {
                return new StringFunctionMethodCallOperator(this.routingContext, parameters).toLower();
            }
            case TOUPPER: {
                return new StringFunctionMethodCallOperator(this.routingContext, parameters).toUpper();
            }
            case TRIM: {
                return new StringFunctionMethodCallOperator(this.routingContext, parameters).trim();
            }
            case SUBSTRING: {
                return new StringFunctionMethodCallOperator(this.routingContext, parameters).substring();
            }
            case CONTAINS: {
                return new StringFunctionMethodCallOperator(this.routingContext, parameters).contains();
            }
            case CONCAT: {
                return new StringFunctionMethodCallOperator(this.routingContext, parameters).concat();
            }
            case LENGTH: {
                return new StringFunctionMethodCallOperator(this.routingContext, parameters).length();
            }
            case YEAR: {
                return new DateFunctionMethodCallOperator(this.routingContext, parameters).year();
            }
            case MONTH: {
                return new DateFunctionMethodCallOperator(this.routingContext, parameters).month();
            }
            case DAY: {
                return new DateFunctionMethodCallOperator(this.routingContext, parameters).day();
            }
            case HOUR: {
                return new DateFunctionMethodCallOperator(this.routingContext, parameters).hour();
            }
            case MINUTE: {
                return new DateFunctionMethodCallOperator(this.routingContext, parameters).minute();
            }
            case SECOND: {
                return new DateFunctionMethodCallOperator(this.routingContext, parameters).second();
            }
            case FRACTIONALSECONDS: {
                return new DateFunctionMethodCallOperator(this.routingContext, parameters).fractionalseconds();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.correlateWith(this.routingContext).debug("Method Call '{}' is not yet implemented.", methodCall);
        }
        return EdmHelper.throwNotImplementedODataException();
    }

    public ExpressionVisitorOperand visitTypeLiteral(EdmType type) throws ExpressionVisitException, ODataApplicationException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.correlateWith(this.routingContext).trace("Visiting Type Literal '{}' is not yet implemented.", type);
        }
        return EdmHelper.throwNotImplementedODataException();
    }

    public ExpressionVisitorOperand visitAlias(String aliasName) throws ExpressionVisitException, ODataApplicationException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.correlateWith(this.routingContext).trace("Visiting Alias '{}' is not yet implemented.", aliasName);
        }
        return EdmHelper.throwNotImplementedODataException();
    }

    public ExpressionVisitorOperand visitEnum(EdmEnumType type, List<String> enumValues) throws ExpressionVisitException, ODataApplicationException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.correlateWith(this.routingContext).trace("Visiting Enum of type '{}' with values '{}' is not yet implemented.", type, enumValues);
        }
        return EdmHelper.throwNotImplementedODataException();
    }

    public ExpressionVisitorOperand visitLambdaExpression(String lambdaFunction, String lambdaVariable, Expression expression) throws ExpressionVisitException, ODataApplicationException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.correlateWith(this.routingContext).trace("Visiting Lambda Expression with function '{}' and variable '{}' is not yet implemented.", lambdaFunction, lambdaVariable);
        }
        return EdmHelper.throwNotImplementedODataException();
    }

    public ExpressionVisitorOperand visitLambdaReference(String variableName) throws ExpressionVisitException, ODataApplicationException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.correlateWith(this.routingContext).trace("Visiting Lambda Reference '{}' is not yet implemented.", variableName);
        }
        return EdmHelper.throwNotImplementedODataException();
    }
}

