/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.expression;

import io.neonbee.endpoint.odatav4.internal.olingo.expression.EntityChainedComparator;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.EntityComparator;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.EntityComparison;
import io.neonbee.logging.LoggingFacade;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;

public final class OrderExpressionExecutor
implements EntityComparison {
    private static final LoggingFacade LOGGER = LoggingFacade.create();

    private OrderExpressionExecutor() {
    }

    public static List<Entity> executeOrderOption(RoutingContext routingContext, OrderByOption orderByOption, List<Entity> entityList) {
        Collections.sort(entityList, new EntityChainedComparator(orderByOption.getOrders().stream().filter(orderByItem -> orderByItem.getExpression() instanceof Member).map(orderByItem -> {
            EdmProperty property;
            UriResource uriResource = (UriResource)((Member)orderByItem.getExpression()).getResourcePath().getUriResourceParts().get(0);
            if (uriResource instanceof UriResourcePrimitiveProperty && (property = ((UriResourcePrimitiveProperty)uriResource).getProperty()).getType().getKind() == EdmTypeKind.PRIMITIVE) {
                String sortPropertyName = property.getName();
                try {
                    return new EntityComparator(routingContext, sortPropertyName, orderByItem.isDescending(), property.getType().toString());
                }
                catch (ODataApplicationException e) {
                    LOGGER.correlateWith(routingContext).error("Failure during order options execution", e);
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList())));
        return entityList;
    }
}

