/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.expression.operands;

import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmConstants;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.EntityComparison;
import io.neonbee.logging.LoggingFacade;
import io.vertx.ext.web.RoutingContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;

public class ExpressionVisitorOperand
implements EntityComparison {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    protected Object value;
    private final EdmType type;
    private final EdmProperty edmProperty;
    private final RoutingContext routingContext;

    public ExpressionVisitorOperand(RoutingContext routingContext, Object value, EdmType type) {
        this(routingContext, value, type, null);
    }

    public ExpressionVisitorOperand(RoutingContext routingContext, Object value, EdmType type, EdmProperty edmProperty) {
        this.routingContext = routingContext;
        this.value = value;
        this.type = type;
        this.edmProperty = edmProperty;
    }

    public ExpressionVisitorOperand normalizeTypes(ExpressionVisitorOperand otherOperand) throws ODataApplicationException {
        ExpressionVisitorOperand other = otherOperand.setType();
        EdmType otherType = other.getType();
        if (this.type.equals(otherType) && this.value != null && other.getValue() != null && this.value.getClass() == other.getValue().getClass() || this.is(EdmConstants.PRIMITIVE_NULL) || other.is(EdmConstants.PRIMITIVE_NULL)) {
            return this;
        }
        if (this.type.equals(EdmConstants.PRIMITIVE_DOUBLE) || otherType.equals(EdmConstants.PRIMITIVE_DOUBLE)) {
            return this.setType(EdmConstants.PRIMITIVE_DOUBLE);
        }
        if (this.type.equals(EdmConstants.PRIMITIVE_SINGLE) || otherType.equals(EdmConstants.PRIMITIVE_SINGLE)) {
            return this.setType(EdmConstants.PRIMITIVE_SINGLE);
        }
        if (this.type.equals(EdmConstants.PRIMITIVE_DECIMAL) || otherType.equals(EdmConstants.PRIMITIVE_DECIMAL)) {
            return this.setType(EdmConstants.PRIMITIVE_DECIMAL);
        }
        if (this.type.equals(EdmConstants.PRIMITIVE_INT64) || otherType.equals(EdmConstants.PRIMITIVE_INT64)) {
            return this.setType(EdmConstants.PRIMITIVE_INT64);
        }
        if (this.type.equals(EdmConstants.PRIMITIVE_INT32) || otherType.equals(EdmConstants.PRIMITIVE_INT32)) {
            return this.setType(EdmConstants.PRIMITIVE_INT32);
        }
        if (this.type.equals(EdmConstants.PRIMITIVE_INT16) || otherType.equals(EdmConstants.PRIMITIVE_INT16)) {
            return this.setType(EdmConstants.PRIMITIVE_INT16);
        }
        return this.setType((EdmPrimitiveType)this.type);
    }

    public ExpressionVisitorOperand setType() throws ODataApplicationException {
        if (this.isNull()) {
            return this;
        }
        if (this.type instanceof EdmPrimitiveType && !(this.value instanceof Collection)) {
            return this.value.getClass() == this.getDefaultType((EdmPrimitiveType)this.type) ? this : this.setType((EdmPrimitiveType)this.type);
        }
        String message = "A single primitive-type instance is expected. A collection of primitive-types is currently not supported.";
        LOGGER.correlateWith(this.routingContext).error(message);
        throw new ODataApplicationException(message, HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH);
    }

    public ExpressionVisitorOperand setType(EdmPrimitiveType type) throws ODataApplicationException {
        if (this.is(EdmConstants.PRIMITIVE_NULL)) {
            return this;
        }
        if (this.isNull()) {
            return new ExpressionVisitorOperand(this.routingContext, null, (EdmType)type);
        }
        Object newValue = null;
        Throwable exception = null;
        if (type.equals(EdmConstants.PRIMITIVE_BOOLEAN)) {
            newValue = Boolean.valueOf((String)this.value);
        } else if (type.equals(EdmConstants.PRIMITIVE_SBYTE) || type.equals(EdmConstants.PRIMITIVE_BYTE) || type.equals(EdmConstants.PRIMITIVE_INT16) || type.equals(EdmConstants.PRIMITIVE_INT32) || type.equals(EdmConstants.PRIMITIVE_INT64)) {
            if (this.value instanceof BigInteger) {
                newValue = this.value;
            } else if (this.value instanceof Byte || this.value instanceof Short || this.value instanceof Integer || this.value instanceof Long) {
                newValue = BigInteger.valueOf(((Number)this.value).longValue());
            } else if (this.value instanceof String) {
                newValue = new BigInteger(String.valueOf(this.value));
            }
        } else if (type.equals(EdmConstants.PRIMITIVE_DOUBLE) || type.equals(EdmConstants.PRIMITIVE_SINGLE) || type.equals(EdmConstants.PRIMITIVE_DECIMAL)) {
            try {
                newValue = new BigDecimal(this.value.toString());
            }
            catch (NumberFormatException e) {
                exception = e;
            }
        } else if (EdmConstants.PRIMITIVE_DATE.equals(type) || EdmConstants.PRIMITIVE_DATE_TIME_OFFSET.equals(type)) {
            newValue = this.dateTimeObjectToInstant(this.routingContext, this.value);
        } else {
            try {
                String literal = this.getLiteral(this.value);
                newValue = this.cast(type.fromUriLiteral(literal), type);
            }
            catch (EdmPrimitiveTypeException e) {
                exception = e;
            }
        }
        if (newValue != null) {
            return new ExpressionVisitorOperand(this.routingContext, newValue, (EdmType)type);
        }
        String message = "Cast of value with type" + this.value.getClass() + " to type " + type + " failed.";
        LOGGER.correlateWith(this.routingContext).error(message);
        throw new ODataApplicationException(message, HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ENGLISH, exception);
    }

    public EdmProperty getEdmProperty() {
        return this.edmProperty;
    }

    public EdmType getType() {
        return this.type;
    }

    public <T> T getTypedValue(Class<T> clazz) {
        return clazz.cast(this.value);
    }

    public boolean is(EdmPrimitiveType ... types) {
        return Arrays.stream(types).anyMatch(t -> t.equals(this.type));
    }

    public boolean isBooleanType() {
        return this.is(EdmConstants.PRIMITIVE_BOOLEAN);
    }

    public boolean isDecimalType() {
        return this.is(EdmConstants.PRIMITIVE_NULL, EdmConstants.PRIMITIVE_SINGLE, EdmConstants.PRIMITIVE_DOUBLE, EdmConstants.PRIMITIVE_DECIMAL);
    }

    public boolean isIntegerType() {
        return this.is(EdmConstants.PRIMITIVE_NULL, EdmConstants.PRIMITIVE_BYTE, EdmConstants.PRIMITIVE_SBYTE, EdmConstants.PRIMITIVE_INT16, EdmConstants.PRIMITIVE_INT32, EdmConstants.PRIMITIVE_INT64);
    }

    public boolean isNull() {
        return this.is(EdmConstants.PRIMITIVE_NULL) || this.value == null;
    }

    public String toString() {
        return "ExpressionVisitorOperand [type=" + this.type + ", edmProperty=" + this.edmProperty + ']';
    }

    private Object cast(String value, EdmPrimitiveType type) throws EdmPrimitiveTypeException {
        try {
            EdmProperty edmProperty = this.getEdmProperty();
            if (edmProperty == null) {
                return type.valueOfString(value, null, null, null, null, null, this.getDefaultType(type));
            }
            return type.valueOfString(value, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(edmProperty.isUnicode()), this.getDefaultType(type));
        }
        catch (EdmPrimitiveTypeException e) {
            LOGGER.error("Can't cast EdmPrimitiveType: {}", value, (Object)e);
            return null;
        }
    }

    private Class<?> getDefaultType(EdmPrimitiveType type) {
        return EdmConstants.TYPE_MAPPINGS.get(type) != null ? EdmConstants.TYPE_MAPPINGS.get(type) : type.getDefaultType();
    }

    public Object getValue() {
        return this.value;
    }

    private String getLiteral(Object value) throws EdmPrimitiveTypeException {
        String uriLiteral = this.getEdmProperty() != null ? ((EdmPrimitiveType)this.type).valueToString(value, Boolean.valueOf(this.getEdmProperty().isNullable()), this.getEdmProperty().getMaxLength(), this.getEdmProperty().getPrecision(), this.getEdmProperty().getScale(), Boolean.valueOf(this.getEdmProperty().isUnicode())) : ((EdmPrimitiveType)this.type).valueToString(value, null, null, null, null, null);
        return ((EdmPrimitiveType)this.type).toUriLiteral(uriLiteral);
    }
}

