/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.expression.operators;

import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmConstants;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.operands.ExpressionVisitorOperand;
import io.neonbee.logging.LoggingFacade;
import io.vertx.ext.web.RoutingContext;
import java.util.Locale;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;

public class UnaryOperator {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private final RoutingContext routingContext;
    private final ExpressionVisitorOperand operand;

    public UnaryOperator(RoutingContext routingContext, ExpressionVisitorOperand operand) throws ODataApplicationException {
        this.routingContext = routingContext;
        this.operand = operand.setType();
    }

    public ExpressionVisitorOperand notOperation() throws ODataApplicationException {
        if (this.operand.isNull()) {
            return this.operand;
        }
        if (this.operand.is(EdmConstants.PRIMITIVE_BOOLEAN)) {
            return new ExpressionVisitorOperand(this.routingContext, this.operand.getTypedValue(Boolean.class) == false, this.operand.getType());
        }
        LOGGER.correlateWith(this.routingContext).error("Unsupported type: {}", this.operand.getType());
        throw new ODataApplicationException("Unsupported type: " + this.operand.getType(), HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ENGLISH);
    }
}

