/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.processor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.AsynchronousProcessor;
import io.neonbee.internal.helper.AsyncHelper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.batch.BatchFacade;
import org.apache.olingo.server.api.deserializer.batch.BatchOptions;
import org.apache.olingo.server.api.deserializer.batch.BatchRequestPart;
import org.apache.olingo.server.api.deserializer.batch.ODataResponsePart;
import org.apache.olingo.server.api.serializer.BatchSerializerException;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_INTERFACE"}, justification="Common practice in Olingo to name the implementation of the processor same as the interface")
public class BatchProcessor
extends AsynchronousProcessor
implements org.apache.olingo.server.api.processor.BatchProcessor {
    private OData odata;

    public BatchProcessor(Vertx vertx, RoutingContext routingContext, Promise<Void> processPromise) {
        super(vertx, routingContext, processPromise);
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
    }

    public void processBatch(BatchFacade facade, ODataRequest request, ODataResponse response) throws ODataApplicationException, ODataLibraryException {
        String boundary = facade.extractBoundaryFromContentType(request.getHeader("Content-Type"));
        BatchOptions options = BatchOptions.with().rawBaseUri(request.getRawBaseUri()).rawServiceResolutionUri(request.getRawServiceResolutionUri()).build();
        List requestParts = this.odata.createFixedFormatDeserializer().parseBatchRequest(request.getBody(), boundary, options);
        Promise<Void> processPromise = this.enterBatchProcessing();
        ArrayList<ODataResponsePart> responseParts = new ArrayList<ODataResponsePart>();
        for (BatchRequestPart part : requestParts) {
            responseParts.add(facade.handleBatchRequest(part));
        }
        AsyncHelper.allComposite(this.wrapUpBatchProcessing()).onComplete(resultHandler -> {
            if (resultHandler.failed()) {
                processPromise.fail(resultHandler.cause());
                return;
            }
            try {
                String responseBoundary = "batch_" + UUID.randomUUID().toString();
                InputStream responseContent = this.odata.createFixedFormatSerializer().batchResponse(responseParts, responseBoundary);
                response.setHeader("Content-Type", ContentType.MULTIPART_MIXED + ";boundary=" + responseBoundary);
                response.setContent(responseContent);
                response.setStatusCode(HttpStatusCode.ACCEPTED.getStatusCode());
                processPromise.complete();
            }
            catch (BatchSerializerException e) {
                processPromise.fail((Throwable)e);
            }
        });
    }

    public ODataResponsePart processChangeSet(BatchFacade facade, List<ODataRequest> requests) throws ODataApplicationException, ODataLibraryException {
        ArrayList<ODataResponse> responses = new ArrayList<ODataResponse>();
        for (ODataRequest request : requests) {
            ODataResponse response = facade.handleODataRequest(request);
            int statusCode = response.getStatusCode();
            if (statusCode < HttpResponseStatus.BAD_REQUEST.code()) {
                responses.add(response);
                continue;
            }
            return new ODataResponsePart(response, false);
        }
        return new ODataResponsePart(responses, true);
    }
}

