/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.processor;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.neonbee.data.DataAction;
import io.neonbee.endpoint.odatav4.internal.olingo.edm.EdmHelper;
import io.neonbee.endpoint.odatav4.internal.olingo.expression.EntityComparison;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.AsynchronousProcessor;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.EntityExpander;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.NavigationPropertyHelper;
import io.neonbee.endpoint.odatav4.internal.olingo.processor.ProcessorHelper;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_INTERFACE"}, justification="Common practice in Olingo to name the implementation of the processor same as the interface")
public class EntityProcessor
extends AsynchronousProcessor
implements org.apache.olingo.server.api.processor.EntityProcessor {
    @VisibleForTesting
    static final UnsupportedOperationException TOO_MANY_PARTS_EXCEPTION = new UnsupportedOperationException("Read requests with more than two resource parts are not supported.");
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final EntityComparison ENTITY_COMPARISON = new EntityComparison(){};
    private OData odata;
    private ServiceMetadata serviceMetadata;

    public EntityProcessor(Vertx vertx, RoutingContext routingContext, Promise<Void> processPromise) {
        super(vertx, routingContext, processPromise);
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    public void readEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) {
        if (uriInfo.getUriResourceParts().size() > 2) {
            throw TOO_MANY_PARTS_EXCEPTION;
        }
        Promise<Void> processPromise = this.getProcessPromise();
        ProcessorHelper.forwardRequest(request, DataAction.READ, uriInfo, this.vertx, this.routingContext, processPromise).onSuccess(this.handleReadEntityResult(uriInfo, response, responseFormat, processPromise));
    }

    public void createEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataLibraryException {
        Promise<Void> processPromise = this.getProcessPromise();
        UriResourceEntitySet uriResourceEntitySet = (UriResourceEntitySet)uriInfo.getUriResourceParts().get(0);
        Entity entity = this.parseBody(request, uriResourceEntitySet, requestFormat);
        ProcessorHelper.forwardRequest(request, DataAction.CREATE, entity, uriInfo, this.vertx, this.routingContext, processPromise).onSuccess(ew -> {
            response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
            processPromise.complete();
        });
    }

    public void updateEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataLibraryException {
        Promise<Void> processPromise = this.getProcessPromise();
        UriResourceEntitySet uriResourceEntitySet = (UriResourceEntitySet)uriInfo.getUriResourceParts().get(0);
        Entity entity = this.parseBody(request, uriResourceEntitySet, requestFormat);
        EdmHelper.addKeyPredicateValues(entity, uriResourceEntitySet, this.routingContext);
        ProcessorHelper.forwardRequest(request, DataAction.UPDATE, entity, uriInfo, this.vertx, this.routingContext, processPromise).onSuccess(ew -> {
            response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
            processPromise.complete();
        });
    }

    public void deleteEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo) {
        Promise<Void> processPromise = this.getProcessPromise();
        ProcessorHelper.forwardRequest(request, DataAction.DELETE, uriInfo, this.vertx, this.routingContext, processPromise).onSuccess(ew -> {
            response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
            processPromise.complete();
        });
    }

    private Entity parseBody(ODataRequest request, UriResourceEntitySet uriResourceEntitySet, ContentType requestFormat) throws DeserializerException {
        EdmEntityType entityType = uriResourceEntitySet.getEntitySet().getEntityType();
        return this.odata.createDeserializer(requestFormat).entity(request.getBody(), entityType).getEntity();
    }

    private Handler<EntityWrapper> handleReadEntityResult(UriInfo uriInfo, ODataResponse response, ContentType responseFormat, Promise<Void> processPromise) {
        return ew -> {
            try {
                UriResourceEntitySet uriResourceEntitySet = (UriResourceEntitySet)uriInfo.getUriResourceParts().get(0);
                Entity foundEntity = EntityProcessor.findEntityByKeyPredicates(this.routingContext, uriResourceEntitySet, ew.getEntities());
                if (foundEntity == null) {
                    response.setStatusCode(HttpStatusCode.NOT_FOUND.getStatusCode());
                    processPromise.complete();
                } else {
                    List resourceParts = uriInfo.getUriResourceParts();
                    Promise responsePromise = Promise.promise();
                    if (resourceParts.size() == 1) {
                        EntityExpander.create(this.vertx, uriInfo.getExpandOption(), this.routingContext).map(expander -> {
                            expander.expand(foundEntity);
                            return foundEntity;
                        }).onComplete((Handler)responsePromise);
                    } else {
                        NavigationPropertyHelper.fetchNavigationTargetEntity((UriResource)resourceParts.get(1), foundEntity, this.vertx, this.routingContext).onComplete((Handler)responsePromise);
                    }
                    responsePromise.future().onSuccess(entityToReturn -> {
                        try {
                            EdmEntitySet edmEntitySet = NavigationPropertyHelper.chooseEntitySet(resourceParts, uriResourceEntitySet.getEntitySet(), this.routingContext);
                            String selectList = this.odata.createUriHelper().buildContextURLSelectList((EdmStructuredType)edmEntitySet.getEntityType(), uriInfo.getExpandOption(), uriInfo.getSelectOption());
                            ContextURL contextUrl = ContextURL.with().entitySet(edmEntitySet).selectList(selectList).build();
                            EntitySerializerOptions opts = EntitySerializerOptions.with().contextURL(contextUrl).select(uriInfo.getSelectOption()).expand(uriInfo.getExpandOption()).build();
                            response.setContent(this.odata.createSerializer(responseFormat).entity(this.serviceMetadata, edmEntitySet.getEntityType(), entityToReturn, opts).getContent());
                            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
                            response.setHeader("Content-Type", responseFormat.toContentTypeString());
                            processPromise.complete();
                        }
                        catch (ODataApplicationException | SerializerException e) {
                            processPromise.fail(e);
                        }
                    }).onFailure(arg_0 -> ((Promise)processPromise).fail(arg_0));
                }
            }
            catch (ODataApplicationException e) {
                processPromise.fail((Throwable)e);
            }
        };
    }

    static Entity findEntityByKeyPredicates(RoutingContext routingContext, UriResourceEntitySet uriResourceEntitySet, List<Entity> entities) throws ODataApplicationException {
        if (entities == null || entities.isEmpty()) {
            return null;
        }
        Map<String, String> keyPredicates = uriResourceEntitySet.getKeyPredicates().stream().collect(Collectors.toUnmodifiableMap(UriParameter::getName, UriParameter::getText));
        Set<String> keyPropertyNames = keyPredicates.keySet();
        List foundEntities = entities.stream().filter(Objects::nonNull).filter(entity -> {
            List propertyNames = entity.getProperties().stream().filter(Objects::nonNull).map(Property::getName).collect(Collectors.toUnmodifiableList());
            return propertyNames.containsAll(keyPropertyNames) && keyPropertyNames.stream().filter(Objects::nonNull).allMatch(keyPropertyName -> {
                String keyPropertyValue = EdmHelper.extractValueFromLiteral(routingContext, (String)keyPredicates.get(keyPropertyName));
                try {
                    EdmPrimitiveTypeKind edmPrimitiveTypeKind = EdmHelper.getEdmPrimitiveTypeKindByPropertyType(uriResourceEntitySet.getEntitySet().getEntityType().getProperty(keyPropertyName).getType().toString());
                    Property property = entity.getProperty(keyPropertyName);
                    Object propertyValue = property.getValue();
                    return ENTITY_COMPARISON.comparePropertyValues(routingContext, propertyValue, keyPropertyValue, edmPrimitiveTypeKind, (String)keyPropertyName) == 0;
                }
                catch (ODataApplicationException e) {
                    LOGGER.correlateWith(routingContext).error(e.getMessage(), e);
                    return false;
                }
            });
        }).collect(Collectors.toUnmodifiableList());
        if (foundEntities.size() == 1) {
            return (Entity)foundEntities.get(0);
        }
        if (foundEntities.size() > 1) {
            throw new ODataApplicationException("Error during processing the request. More than one entity with the same ids (key properties) was found, but ids (key properties) have to be unique.", HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ENGLISH);
        }
        return null;
    }
}

