/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.processor;

import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.entity.EntityVerticle;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmReferentialConstraint;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceNavigation;

public final class NavigationPropertyHelper {
    private static final LoggingFacade LOGGER = LoggingFacade.create();

    public static Future<List<Entity>> fetchReferencedEntities(EdmNavigationProperty navigationProperty, Vertx vertx, RoutingContext routingContext) {
        FullQualifiedName fqn = navigationProperty.getType().getFullQualifiedName();
        DataRequest req = new DataRequest(fqn, new DataQuery(fqn.getNamespace() + "/" + fqn.getName()));
        return EntityVerticle.requestEntity(vertx, req, new DataContextImpl(routingContext)).map(EntityWrapper::getEntities);
    }

    public static List<Entity> getRelatedEntities(EdmNavigationProperty navigationProperty, Entity sourceEntity, List<Entity> referencedEntities) {
        ArrayList<Entity> filteredEntities = new ArrayList<Entity>(referencedEntities);
        boolean isCollection = navigationProperty.isCollection();
        List constraints = isCollection ? navigationProperty.getPartner().getReferentialConstraints() : navigationProperty.getReferentialConstraints();
        for (EdmReferentialConstraint constraint : constraints) {
            String propertyName = isCollection ? constraint.getReferencedPropertyName() : constraint.getPropertyName();
            String referencePropertyName = isCollection ? constraint.getPropertyName() : constraint.getReferencedPropertyName();
            Object propertyValue = sourceEntity.getProperty(propertyName).getValue();
            List<Entity> remainingEntities = List.copyOf(filteredEntities);
            filteredEntities.clear();
            for (Entity referenceEntity : remainingEntities) {
                Object referencePropertyValue = referenceEntity.getProperty(referencePropertyName).getValue();
                if (!propertyValue.equals(referencePropertyValue)) continue;
                filteredEntities.add(referenceEntity);
            }
        }
        return filteredEntities;
    }

    public static EdmEntitySet getNavigationTargetEntitySet(EdmEntitySet uriResourceEntitySet, EdmNavigationProperty edmNavigationProperty, RoutingContext routingContext) throws ODataApplicationException {
        try {
            String navPropName = edmNavigationProperty.getName();
            return (EdmEntitySet)uriResourceEntitySet.getRelatedBindingTarget(navPropName);
        }
        catch (Exception e) {
            String msg = "Can't retrieve entity set of navigation target.";
            LOGGER.correlateWith(routingContext).error(msg, e);
            throw new ODataApplicationException(msg, HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ROOT, (Throwable)e);
        }
    }

    public static Future<Entity> fetchNavigationTargetEntity(UriResource navigationPart, Entity sourceEntity, Vertx vertx, RoutingContext routingContext) {
        return NavigationPropertyHelper.fetchNavigationTargetEntities(navigationPart, sourceEntity, vertx, routingContext).compose(entities -> {
            if (entities.size() == 1) {
                return Future.succeededFuture((Object)((Entity)entities.get(0)));
            }
            LOGGER.correlateWith(routingContext).error("Expected one target entity but got: {}", entities.size());
            return Future.failedFuture((String)"Unexpected error occur during fetching navigation target");
        });
    }

    public static Future<List<Entity>> fetchNavigationTargetEntities(UriResource navigationPart, Entity sourceEntity, Vertx vertx, RoutingContext routingContext) {
        if (navigationPart instanceof UriResourceNavigation) {
            EdmNavigationProperty edmNavigationProperty = ((UriResourceNavigation)navigationPart).getProperty();
            return NavigationPropertyHelper.fetchReferencedEntities(edmNavigationProperty, vertx, routingContext).map(entities -> NavigationPropertyHelper.getRelatedEntities(edmNavigationProperty, sourceEntity, entities));
        }
        return Future.failedFuture((String)"Expected second path segment to be a navigation property");
    }

    public static EdmEntitySet chooseEntitySet(List<UriResource> resourceParts, EdmEntitySet resourceEntitySet, RoutingContext routingContext) throws ODataApplicationException {
        if (resourceParts.size() == 1) {
            return resourceEntitySet;
        }
        EdmNavigationProperty navProb = ((UriResourceNavigation)resourceParts.get(1)).getProperty();
        return NavigationPropertyHelper.getNavigationTargetEntitySet(resourceEntitySet, navProb, routingContext);
    }

    private NavigationPropertyHelper() {
    }
}

