/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.openapi;

import io.neonbee.endpoint.Endpoint;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.openapi.RouterBuilder;
import org.slf4j.Logger;

public abstract class AbstractOpenAPIEndpoint
implements Endpoint {
    private static final Logger LOGGER = LoggingFacade.create();

    @Override
    public Future<Router> createEndpointRouter(Vertx vertx, String basePath, JsonObject config) {
        return this.getOpenAPIContractURL(vertx, config).compose(contractPath -> RouterBuilder.create((Vertx)vertx, (String)contractPath)).onFailure(err -> LOGGER.error("Error while parsing the OpenAPI Contract", err)).compose(rb -> this.createRouter(vertx, (RouterBuilder)rb));
    }

    protected abstract Future<String> getOpenAPIContractURL(Vertx var1, JsonObject var2);

    protected abstract Future<Router> createRouter(Vertx var1, RouterBuilder var2);
}

