/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.sap.cds.reflect.CdsModel;
import java.util.Map;
import java.util.Objects;
import org.apache.olingo.server.api.ServiceMetadata;

public final class EntityModel {
    private final CdsModel csnModel;
    private final Map<String, ServiceMetadata> edmxMap;

    private EntityModel(CdsModel csnModel, Map<String, ServiceMetadata> edmxMap) {
        this.csnModel = Objects.requireNonNull(csnModel);
        this.edmxMap = Map.copyOf(edmxMap);
    }

    static EntityModel of(CdsModel csmModel, Map<String, ServiceMetadata> edmxMap) {
        return new EntityModel(csmModel, edmxMap);
    }

    @Deprecated(forRemoval=true)
    public CdsModel getCsn() {
        return this.getCsnModel();
    }

    @Deprecated(forRemoval=true)
    public ServiceMetadata getEdmx() {
        return this.getEdmxMetadata();
    }

    @Deprecated(forRemoval=true)
    public ServiceMetadata getEdmx(String namespace) {
        return this.getEdmxMetadata(namespace);
    }

    @Deprecated
    public Map<String, ServiceMetadata> getEdmxes() {
        return this.getAllEdmxMetadata();
    }

    public CdsModel getCsnModel() {
        return this.csnModel;
    }

    public ServiceMetadata getEdmxMetadata() {
        return this.edmxMap.values().stream().findFirst().orElse(null);
    }

    public ServiceMetadata getEdmxMetadata(String namespace) {
        return this.edmxMap.get(namespace);
    }

    public Map<String, ServiceMetadata> getAllEdmxMetadata() {
        return this.edmxMap;
    }
}

