/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import io.neonbee.internal.codec.EntityWrapperMessageCodec;
import io.neonbee.internal.helper.CollectionHelper;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class EntityWrapper {
    private FullQualifiedName typeName;
    private List<Entity> entities;

    public EntityWrapper(String typeNamespaceAndName, Entity entity) {
        this(typeNamespaceAndName, entity != null ? Collections.singletonList(entity) : Collections.emptyList());
    }

    public EntityWrapper(String typeNamespaceAndName, List<Entity> entities) {
        this(new FullQualifiedName(typeNamespaceAndName), entities);
    }

    public EntityWrapper(FullQualifiedName typeName, Entity entity) {
        this(typeName, entity != null ? Collections.singletonList(entity) : Collections.emptyList());
    }

    public EntityWrapper(FullQualifiedName typeName, List<Entity> entities) {
        this.typeName = typeName;
        this.entities = CollectionHelper.mutableCopyOf(entities);
    }

    public FullQualifiedName getTypeName() {
        return this.typeName;
    }

    public Entity getEntity() {
        return this.entities.stream().findFirst().orElse(null);
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public int hashCode() {
        return Objects.hash(this.entities, this.typeName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityWrapper)) {
            return false;
        }
        EntityWrapper other = (EntityWrapper)obj;
        return Objects.equals(this.entities, other.entities) && Objects.equals(this.typeName, other.typeName);
    }

    public Buffer toBuffer(Vertx vertx) {
        EntityWrapperMessageCodec codec = new EntityWrapperMessageCodec(vertx);
        Buffer buffer = Buffer.buffer();
        codec.encodeToWire(buffer, this);
        return buffer;
    }

    public static EntityWrapper fromBuffer(Vertx vertx, Buffer buffer) {
        EntityWrapperMessageCodec codec = new EntityWrapperMessageCodec(vertx);
        return codec.decodeFromWire(0, buffer);
    }
}

