/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.health;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.core.HazelcastInstance;
import io.neonbee.NeonBee;
import io.neonbee.health.AbstractHealthCheck;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.Status;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.util.function.Function;

public class HazelcastClusterHealthCheck
extends AbstractHealthCheck {
    public static final String NAME = "cluster.hazelcast";
    @VisibleForTesting
    static final String EXPECTED_CLUSTER_SIZE_KEY = "expectedClusterSize";
    private final HazelcastClusterManager clusterManager;

    public HazelcastClusterHealthCheck(NeonBee neonBee, HazelcastClusterManager clusterManager) {
        super(neonBee);
        this.clusterManager = clusterManager;
    }

    @Override
    public String getId() {
        return NAME;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public Function<NeonBee, Handler<Promise<Status>>> createProcedure() {
        return neonBee -> healthCheckPromise -> neonBee.getVertx().executeBlocking(promise -> {
            HazelcastInstance instance = this.clusterManager.getHazelcastInstance();
            boolean lifecycleServiceRunning = instance.getLifecycleService().isRunning();
            boolean ok = instance.getPartitionService().isClusterSafe() && lifecycleServiceRunning;
            int clusterSize = instance.getCluster().getMembers().size();
            if (this.config.containsKey(EXPECTED_CLUSTER_SIZE_KEY)) {
                ok = ok && this.config.getInteger(EXPECTED_CLUSTER_SIZE_KEY) == clusterSize;
            }
            promise.complete((Object)new Status().setOk(ok).setData(new JsonObject().put("clusterState", (Object)instance.getCluster().getClusterState()).put("clusterSize", (Object)clusterSize).put("lifecycleServiceState", (Object)(lifecycleServiceRunning ? "ACTIVE" : "INACTIVE"))));
        }, false, (Handler)healthCheckPromise);
    }
}

