/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.health;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.memory.MemorySize;
import io.neonbee.NeonBee;
import io.neonbee.health.AbstractHealthCheck;
import io.neonbee.health.internal.MemoryStats;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.Status;
import java.util.function.Function;

public class MemoryHealthCheck
extends AbstractHealthCheck {
    public static final String NAME = "os.memory";
    @VisibleForTesting
    static final String CRITICAL_THRESHOLD_PERCENTAGE_KEY = "criticalThresholdPercentage";
    private static final Integer DEFAULT_CRITICAL_THRESHOLD_PERCENTAGE = 90;
    private static final double PERCENTAGE_MULTIPLIER = 100.0;
    @VisibleForTesting
    MemoryStats memoryStats = new MemoryStats();

    public MemoryHealthCheck(NeonBee neonBee) {
        super(neonBee);
    }

    @Override
    public String getId() {
        return NAME;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public Function<NeonBee, Handler<Promise<Status>>> createProcedure() {
        return neonBee -> healthCheckPromise -> {
            long usedMemory = this.memoryStats.getUsedHeap();
            double memoryUsedOfTotalPercentage = 100.0 * (double)usedMemory / (double)this.memoryStats.getCommittedHeap();
            double memoryUsedOfMaxPercentage = 100.0 * (double)usedMemory / (double)this.memoryStats.getMaxHeap();
            boolean critical = memoryUsedOfMaxPercentage > (double)this.config.getInteger(CRITICAL_THRESHOLD_PERCENTAGE_KEY, DEFAULT_CRITICAL_THRESHOLD_PERCENTAGE).intValue();
            healthCheckPromise.complete((Object)new Status().setOk(!critical).setData(new JsonObject().put("freeHeapMemory", (Object)MemorySize.toPrettyString((long)this.memoryStats.getFreeHeap())).put("memoryUsedOfTotalPercentage", (Object)MemoryHealthCheck.printPercentage(memoryUsedOfTotalPercentage)).put("memoryUsedOfMaxPercentage", (Object)MemoryHealthCheck.printPercentage(memoryUsedOfMaxPercentage))));
        };
    }

    private static String printPercentage(double percentage) {
        return String.format("%.2f%%", percentage);
    }
}

