/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.hook;

import io.neonbee.hook.HookRegistration;
import io.neonbee.hook.HookType;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import java.util.Collection;
import java.util.Map;

public interface HookRegistry {
    default public Future<Collection<HookRegistration>> registerHooks(Class<?> hookClass, String correlationId) {
        try {
            return this.registerInstanceHooks(hookClass.getConstructor(new Class[0]).newInstance(new Object[0]), correlationId);
        }
        catch (Exception e) {
            LoggingFacade.create().correlateWith(correlationId).error("Could not initialize object for class {} containing hook.", hookClass.getName(), e);
            return Future.failedFuture((Throwable)e);
        }
    }

    public Future<Collection<HookRegistration>> registerInstanceHooks(Object var1, String var2);

    default public CompositeFuture executeHooks(HookType type) {
        return this.executeHooks(type, Map.of());
    }

    public CompositeFuture executeHooks(HookType var1, Map<String, Object> var2);

    public Future<Collection<HookRegistration>> getHookRegistrations();
}

