/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.hook.internal;

import io.neonbee.hook.HookRegistration;
import io.neonbee.hook.HookType;
import io.neonbee.hook.internal.DefaultHookRegistry;
import io.vertx.core.Future;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.UUID;

public final class DefaultHookRegistration
implements HookRegistration {
    private final String id;
    private final HookType type;
    private final DefaultHookRegistry registry;
    private final Method hookMethod;
    private final Object relatedObject;

    DefaultHookRegistration(DefaultHookRegistry registry, Object relatedObject, Method hookMethod, HookType type) {
        this.registry = registry;
        this.relatedObject = relatedObject;
        this.hookMethod = hookMethod;
        this.type = type;
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return String.format("%s::%s", this.relatedObject.getClass().getName(), this.hookMethod.getName());
    }

    @Override
    public HookType getType() {
        return this.type;
    }

    Method getHookMethod() {
        return this.hookMethod;
    }

    Object getRelatedObject() {
        return this.relatedObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultHookRegistration that = (DefaultHookRegistration)o;
        return this.getHookMethod().equals(that.getHookMethod()) && this.getRelatedObject().equals(that.getRelatedObject()) && this.getType() == that.getType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getHookMethod(), this.getRelatedObject(), this.getType()});
    }

    @Override
    public Future<Void> unregister() {
        this.registry.hookRegistry.get((Object)this.getType()).remove(this);
        return Future.succeededFuture();
    }
}

