/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;

public final class ImmutableBuffer
implements Buffer {
    public static final ImmutableBuffer EMPTY = new ImmutableBuffer();
    private final Buffer buffer;

    public static ImmutableBuffer buffer() {
        return EMPTY;
    }

    public static ImmutableBuffer buffer(Buffer buffer) {
        return buffer instanceof ImmutableBuffer ? (ImmutableBuffer)buffer : new ImmutableBuffer(buffer);
    }

    ImmutableBuffer() {
        this(Unpooled.EMPTY_BUFFER);
    }

    ImmutableBuffer(Buffer buffer) {
        this(Objects.requireNonNull(buffer), buffer.getByteBuf());
    }

    ImmutableBuffer(ByteBuf byteBuffer) {
        this(Buffer.buffer((ByteBuf)byteBuffer), byteBuffer);
    }

    private ImmutableBuffer(Buffer buffer, ByteBuf byteBuffer) {
        this.buffer = byteBuffer.isReadOnly() ? buffer : Buffer.buffer((ByteBuf)byteBuffer.asReadOnly());
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Buffer getBuffer(int start, int end) {
        return this.buffer.getBuffer(start, end);
    }

    public void writeToBuffer(Buffer buffer) {
        throw new UnsupportedOperationException();
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        return buffer.readFromBuffer(pos, buffer);
    }

    public JsonObject toJsonObject() {
        return this.buffer.toJsonObject();
    }

    public JsonArray toJsonArray() {
        return this.buffer.toJsonArray();
    }

    public byte getByte(int pos) {
        return this.buffer.getByte(pos);
    }

    public short getUnsignedByte(int pos) {
        return this.buffer.getUnsignedByte(pos);
    }

    public int getInt(int pos) {
        return this.buffer.getInt(pos);
    }

    public int getIntLE(int pos) {
        return this.buffer.getIntLE(pos);
    }

    public long getUnsignedInt(int pos) {
        return this.buffer.getUnsignedInt(pos);
    }

    public long getUnsignedIntLE(int pos) {
        return this.buffer.getUnsignedIntLE(pos);
    }

    public long getLong(int pos) {
        return this.buffer.getLong(pos);
    }

    public long getLongLE(int pos) {
        return this.buffer.getLongLE(pos);
    }

    public double getDouble(int pos) {
        return this.buffer.getDouble(pos);
    }

    public float getFloat(int pos) {
        return this.buffer.getFloat(pos);
    }

    public short getShort(int pos) {
        return this.buffer.getShort(pos);
    }

    public short getShortLE(int pos) {
        return this.buffer.getShortLE(pos);
    }

    public int getUnsignedShort(int pos) {
        return this.buffer.getUnsignedShort(pos);
    }

    public int getUnsignedShortLE(int pos) {
        return this.buffer.getUnsignedShortLE(pos);
    }

    public int getMedium(int pos) {
        return this.buffer.getMedium(pos);
    }

    public int getMediumLE(int pos) {
        return this.buffer.getMediumLE(pos);
    }

    public int getUnsignedMedium(int pos) {
        return this.buffer.getUnsignedMedium(pos);
    }

    public int getUnsignedMediumLE(int pos) {
        return this.buffer.getUnsignedMediumLE(pos);
    }

    public byte[] getBytes() {
        return this.buffer.getBytes();
    }

    public byte[] getBytes(int start, int end) {
        return this.buffer.getBytes(start, end);
    }

    public ImmutableBuffer getBytes(byte[] dst) {
        this.buffer.getBytes(dst);
        return this;
    }

    public ImmutableBuffer getBytes(byte[] dst, int dstIndex) {
        this.buffer.getBytes(dst, dstIndex);
        return this;
    }

    public ImmutableBuffer getBytes(int start, int end, byte[] dst) {
        this.buffer.getBytes(start, end, dst);
        return this;
    }

    public ImmutableBuffer getBytes(int start, int end, byte[] dst, int dstIndex) {
        this.buffer.getBytes(start, end, dst, dstIndex);
        return this;
    }

    public String getString(int start, int end, String enc) {
        return this.buffer.getString(start, end, enc);
    }

    public String getString(int start, int end) {
        return this.buffer.getString(start, end);
    }

    public ImmutableBuffer appendBuffer(Buffer buff) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendBuffer(Buffer buff, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendBytes(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendBytes(byte[] bytes, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendByte(byte b) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendUnsignedByte(short b) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendInt(int i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendIntLE(int i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendUnsignedInt(long i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendUnsignedIntLE(long i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendMedium(int i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendMediumLE(int i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendLong(long l) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendLongLE(long l) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendShort(short s) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendShortLE(short s) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendUnsignedShort(int s) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendUnsignedShortLE(int s) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendFloat(float f) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendDouble(double d) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendString(String str, String enc) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer appendString(String str) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setByte(int pos, byte b) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setUnsignedByte(int pos, short b) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setInt(int pos, int i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setIntLE(int pos, int i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setUnsignedInt(int pos, long i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setUnsignedIntLE(int pos, long i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setMedium(int pos, int i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setMediumLE(int pos, int i) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setLong(int pos, long l) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setLongLE(int pos, long l) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setDouble(int pos, double d) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setFloat(int pos, float f) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setShort(int pos, short s) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setShortLE(int pos, short s) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setUnsignedShort(int pos, int s) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setUnsignedShortLE(int pos, int s) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setBuffer(int pos, Buffer b) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setBuffer(int pos, Buffer b, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setBytes(int pos, ByteBuffer b) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setBytes(int pos, byte[] b) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setBytes(int pos, byte[] b, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setString(int pos, String str) {
        throw new UnsupportedOperationException();
    }

    public ImmutableBuffer setString(int pos, String str, String enc) {
        throw new UnsupportedOperationException();
    }

    public int length() {
        return this.buffer.length();
    }

    public ImmutableBuffer slice() {
        return this;
    }

    public ImmutableBuffer slice(int start, int end) {
        return new ImmutableBuffer(this.buffer.slice(start, end));
    }

    public ByteBuf getByteBuf() {
        return this.buffer.getByteBuf();
    }

    public ImmutableBuffer copy() {
        return this;
    }

    public boolean equals(Object other) {
        return this.buffer.equals(other instanceof ImmutableBuffer ? ((ImmutableBuffer)other).buffer : other);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public String toString() {
        return this.buffer.toString();
    }

    public String toString(String enc) {
        return this.buffer.toString(enc);
    }

    public String toString(Charset enc) {
        return this.buffer.toString(enc);
    }

    public Buffer mutableCopy() {
        return this.buffer.length() == 0 ? Buffer.buffer() : Buffer.buffer((byte[])this.buffer.getBytes());
    }
}

