/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.codec;

import io.neonbee.data.DataException;
import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.stream.Collectors;

public class DataExceptionMessageCodec
implements MessageCodec<DataException, DataException> {
    public void encodeToWire(Buffer buffer, DataException exception) {
        buffer.appendInt(exception.failureCode());
        String msgEncoded = exception.getMessage();
        if (msgEncoded != null) {
            byte[] msgBytes = msgEncoded.getBytes(CharsetUtil.UTF_8);
            buffer.appendInt(msgBytes.length);
            buffer.appendBytes(msgBytes);
        } else {
            buffer.appendInt(-1);
        }
        Buffer failureDetailEncoded = new JsonObject(exception.failureDetail()).toBuffer();
        buffer.appendInt(failureDetailEncoded.length());
        buffer.appendBuffer(failureDetailEncoded);
    }

    public DataException decodeFromWire(int pos, Buffer buffer) {
        int tmpPos = pos;
        int failureCode = buffer.getInt(tmpPos);
        int msgLength = buffer.getInt(tmpPos += 4);
        String message = msgLength != -1 ? new String(buffer.getBytes(tmpPos += 4, tmpPos + msgLength), CharsetUtil.UTF_8) : null;
        int failureDetailLength = buffer.getInt(tmpPos += msgLength != -1 ? msgLength : 0);
        Buffer buff = buffer.getBuffer(tmpPos += 4, tmpPos + failureDetailLength);
        Map<String, Object> failureDetail = buff.toJsonObject().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new DataException(failureCode, message, failureDetail);
    }

    public DataException transform(DataException exception) {
        return exception;
    }

    public String name() {
        return "dataexception";
    }

    public byte systemCodecID() {
        return -1;
    }
}

