/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.neonbee.NeonBee;
import io.neonbee.internal.SelfFirstClassLoader;
import io.neonbee.internal.deploy.Deployable;
import io.neonbee.internal.deploy.DeployableModels;
import io.neonbee.internal.deploy.DeployableVerticle;
import io.neonbee.internal.deploy.Deployables;
import io.neonbee.internal.deploy.PendingDeployment;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.scanner.ClassPathScanner;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class DeployableModule
extends Deployables {
    public static final String NEONBEE_MODULE = "NeonBee-Module";
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    @VisibleForTesting
    final String moduleName;
    @VisibleForTesting
    final URLClassLoader moduleClassLoader;

    public static Future<DeployableModule> fromJar(Vertx vertx, Path jarPath) {
        LOGGER.debug("Loading {} from JAR {}", DeployableModule.class, jarPath);
        return ClassPathScanner.forJarFile(vertx, jarPath).compose(classPathScanner -> classPathScanner.scanManifestFiles(vertx, NEONBEE_MODULE).compose(moduleNames -> {
            if (moduleNames.isEmpty()) {
                return Future.failedFuture((String)"No NeonBee-Module attribute found");
            }
            if (moduleNames.size() > 1) {
                return Future.failedFuture((String)"Too many NeonBee-Module attributes found");
            }
            String moduleName = (String)moduleNames.get(0);
            LOGGER.debug("Found module with name {}", moduleName);
            AtomicReference<SelfFirstClassLoader> moduleClassLoader = new AtomicReference<SelfFirstClassLoader>(new SelfFirstClassLoader(classPathScanner.getClassLoader().getURLs(), ClassLoader.getSystemClassLoader(), NeonBee.get(vertx).getConfig().getPlatformClasses()));
            Future<Collection<DeployableVerticle>> deployableVerticles = DeployableVerticle.scanClassPath(vertx, classPathScanner, moduleClassLoader.get());
            Future<DeployableModels> deployableModels = DeployableModels.scanClassPath(vertx, classPathScanner);
            return CompositeFuture.all(deployableVerticles, deployableModels).onComplete(scanResult -> {
                if (scanResult.failed() || ((Collection)deployableVerticles.result()).isEmpty()) {
                    try {
                        ((SelfFirstClassLoader)moduleClassLoader.getAndSet(null)).close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Cloud not close the moduleClassLoader, after no verticles have been found to deploy", e);
                    }
                }
            }).map(result -> new DeployableModule(moduleName, (URLClassLoader)moduleClassLoader.get(), Lists.newArrayList((Iterable)Iterables.concat(List.of((DeployableModels)deployableModels.result()), (Iterable)((Iterable)deployableVerticles.result())))));
        }).eventually(classPathScanner.close(vertx)));
    }

    @VisibleForTesting
    DeployableModule(String moduleName, URLClassLoader moduleClassLoader, List<Deployable> deployables) {
        super(deployables);
        this.moduleName = Objects.requireNonNull(moduleName, "moduleName may not be null");
        this.moduleClassLoader = moduleClassLoader;
        if (moduleClassLoader == null) {
            if (deployables.stream().anyMatch(DeployableVerticle.class::isInstance)) {
                throw new IllegalStateException("Missing module class loader for provided deployable verticle(s)");
            }
        }
    }

    @Override
    public String getIdentifier() {
        return this.moduleName;
    }

    @Override
    public List<Deployable> getDeployables() {
        return Collections.unmodifiableList(super.getDeployables());
    }

    @Override
    public PendingDeployment deploy(NeonBee neonBee) {
        return super.deploy(neonBee, undeployResult -> AsyncHelper.executeBlocking(neonBee.getVertx(), () -> {
            if (this.moduleClassLoader != null) {
                this.moduleClassLoader.close();
            }
        }));
    }
}

