/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.internal.deploy.Deployable;
import io.neonbee.internal.deploy.Deployment;
import io.neonbee.internal.deploy.PendingDeployment;
import io.neonbee.internal.helper.AsyncHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Deployables
extends Deployable {
    @VisibleForTesting
    boolean keepPartialDeployment;
    private final List<Deployable> deployables;

    public static Future<Deployables> fromDeployables(List<Future<? extends Deployable>> deployables) {
        return AsyncHelper.allComposite(deployables).map(composite -> composite.list()).map(Deployables::new);
    }

    public Deployables(List<? extends Deployable> deployables) {
        this.deployables = new ArrayList<Deployable>((Collection)Objects.requireNonNull(deployables));
    }

    public static Function<Deployables, Future<Deployment>> allTo(NeonBee neonBee) {
        return deployables -> deployables.deploy(neonBee);
    }

    public static Function<Deployables, Future<Deployment>> anyTo(NeonBee neonBee) {
        return deployables -> {
            PendingDeployment pendingDeployment = deployables.keepPartialDeployment().deploy(neonBee);
            return pendingDeployment.otherwise(pendingDeployment);
        };
    }

    @Override
    public String getType() {
        return Deployables.class.getSimpleName();
    }

    @Override
    public String getIdentifier() {
        return "[" + this.getDeployables().stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
    }

    public List<Deployable> getDeployables() {
        return this.deployables;
    }

    public Deployables keepPartialDeployment() {
        this.keepPartialDeployment = true;
        return this;
    }

    @Override
    public PendingDeployment deploy(NeonBee neonBee) {
        return this.deploy(neonBee, null);
    }

    protected final <T> PendingDeployment deploy(NeonBee neonBee, Function<AsyncResult<CompositeFuture>, Future<T>> afterUndeploy) {
        ArrayList pendingDeployments = new ArrayList();
        final Supplier<Future> undeploy = () -> AsyncHelper.joinComposite(pendingDeployments.stream().map(pendingDeployment -> pendingDeployment.transform(deployResult -> pendingDeployment.undeploy())).collect(Collectors.toList())).transform(undeployResult -> {
            Future afterFuture = afterUndeploy != null ? (Future)afterUndeploy.apply((AsyncResult<CompositeFuture>)undeployResult) : Future.succeededFuture();
            return undeployResult.succeeded() ? afterFuture : afterFuture.transform(anyResult -> Future.failedFuture((Throwable)undeployResult.cause()));
        }).mapEmpty();
        Promise deployPromise = Promise.promise();
        PendingDeployment pendingDeployment = new PendingDeployment(neonBee, this, deployPromise.future().recover(failedDeployment -> (!this.keepPartialDeployment ? (Future)undeploy.get() : Future.succeededFuture()).transform(anyResult -> Future.failedFuture((Throwable)failedDeployment))).map((Object)Integer.toHexString(this.hashCode()))){

            @Override
            protected Future<Void> undeploy(String deploymentId) {
                return (Future)undeploy.get();
            }
        };
        this.getDeployables().stream().map(deployable -> deployable.deploy(neonBee)).forEach(pendingDeployments::add);
        (this.keepPartialDeployment ? AsyncHelper.joinComposite(pendingDeployments) : AsyncHelper.allComposite(pendingDeployments)).onComplete((Handler)deployPromise);
        return pendingDeployment;
    }
}

