/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import io.neonbee.NeonBee;
import io.neonbee.internal.deploy.Deployable;
import io.neonbee.internal.deploy.Deployables;
import io.neonbee.internal.deploy.Deployment;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.FutureInternal;
import io.vertx.core.impl.future.Listener;
import java.util.function.Function;

public abstract class PendingDeployment
extends Deployment
implements FutureInternal<Deployment> {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private final Future<String> deployFuture;

    PendingDeployment(NeonBee neonBee, Deployable deployable, Future<String> deployFuture) {
        super(neonBee, deployable);
        LOGGER.info("Started deployment of {} ...", deployable);
        this.deployFuture = deployFuture.map(deploymentId -> deploymentId != null ? deploymentId : super.getDeploymentId()).onSuccess(deploymentId -> LOGGER.info("Deployment of {} succeeded with ID {}", deployable, deploymentId)).onFailure(throwable -> LOGGER.error("Deployment of {} failed", deployable, throwable));
    }

    @Override
    public final Future<Void> undeploy() {
        Deployable deployable = this.getDeployable();
        if (!this.deployFuture.isComplete()) {
            return Future.failedFuture((Throwable)new IllegalStateException("Cannot undeploy " + deployable.getIdentifier() + ", because deployment is still ongoing."));
        }
        if (this.deployFuture.failed() && !Deployables.class.isInstance(deployable)) {
            return Future.succeededFuture();
        }
        String deployableIdentifier = deployable.getIdentifier();
        String deploymentId = (String)this.deployFuture.result();
        LOGGER.info("Starting to undeploy {} with ID {}", deployableIdentifier, deploymentId);
        return this.undeploy(deploymentId).onSuccess(nothing -> LOGGER.info("Undeployment of {} with ID {} succeeded", deployableIdentifier, deploymentId)).onFailure(throwable -> LOGGER.error("Undeployment of {} with ID {} failed", new Object[]{deployableIdentifier, deploymentId, throwable}));
    }

    protected abstract Future<Void> undeploy(String var1);

    @Override
    public String getDeploymentId() {
        return (String)this.deployFuture.result();
    }

    public boolean isComplete() {
        return this.deployFuture.isComplete();
    }

    public Future<Deployment> onComplete(Handler<AsyncResult<Deployment>> handler) {
        return this.mapDeployment().onComplete(handler);
    }

    public Deployment result() {
        return this.succeeded() ? this : null;
    }

    public Throwable cause() {
        return this.deployFuture.cause();
    }

    public boolean succeeded() {
        return this.deployFuture.succeeded();
    }

    public boolean failed() {
        return this.deployFuture.failed();
    }

    public <U> Future<U> compose(Function<Deployment, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
        return this.mapDeployment().compose(successMapper, failureMapper);
    }

    public <U> Future<U> transform(Function<AsyncResult<Deployment>, Future<U>> mapper) {
        return this.mapDeployment().transform(mapper);
    }

    public <U> Future<Deployment> eventually(Function<Void, Future<U>> mapper) {
        return this.mapDeployment().eventually(mapper);
    }

    public <U> Future<U> map(Function<Deployment, U> mapper) {
        return this.mapDeployment().map(mapper);
    }

    public <V> Future<V> map(V value) {
        return this.mapDeployment().map(value);
    }

    public Future<Deployment> otherwise(Function<Throwable, Deployment> mapper) {
        return this.mapDeployment().otherwise(mapper);
    }

    public Future<Deployment> otherwise(Deployment value) {
        return this.mapDeployment().otherwise((Object)value);
    }

    public ContextInternal context() {
        return ((FutureInternal)this.deployFuture).context();
    }

    public void addListener(Listener<Deployment> listener) {
        ((FutureInternal)this.mapDeployment()).addListener(listener);
    }

    private Future<Deployment> mapDeployment() {
        return this.deployFuture.map((Object)this);
    }
}

