/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.handler;

import io.neonbee.NeonBee;
import io.neonbee.data.DataException;
import io.neonbee.hook.HookType;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;

public class HooksHandler
implements Handler<RoutingContext> {
    private static final LoggingFacade LOGGER = LoggingFacade.create();

    public void handle(RoutingContext routingContext) {
        NeonBee.get(routingContext.vertx()).getHookRegistry().executeHooks(HookType.ONCE_PER_REQUEST, Map.of("routingContext", routingContext)).onComplete(asyncResult -> {
            if (asyncResult.failed()) {
                Throwable cause = asyncResult.cause();
                LOGGER.error("An error has occurred while executing the request hook", cause);
                if (cause instanceof DataException) {
                    routingContext.fail(((DataException)cause).failureCode());
                } else {
                    routingContext.fail(cause);
                }
            } else {
                routingContext.next();
            }
        });
    }
}

