/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.handler.factories;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.config.ServerConfig;
import io.neonbee.internal.handler.factories.RoutingHandlerFactory;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.PlatformHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.ClusteredSessionStore;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.util.Optional;

public class SessionHandlerFactory
implements RoutingHandlerFactory {
    @Override
    public Future<Handler<RoutingContext>> createHandler() {
        ServerConfig config = NeonBee.get().getServerConfig();
        Handler sh = SessionHandlerFactory.createSessionStore(NeonBee.get().getVertx(), config.getSessionHandling()).map(SessionHandler::create).map(sessionHandler -> sessionHandler.setSessionCookieName(config.getSessionCookieName())).map(sessionHandler -> sessionHandler).orElseGet(NoOpHandler::new);
        return Future.succeededFuture((Object)sh);
    }

    @VisibleForTesting
    static Optional<SessionStore> createSessionStore(Vertx vertx, ServerConfig.SessionHandling sessionHandling) {
        switch (sessionHandling) {
            case LOCAL: {
                return Optional.of(LocalSessionStore.create((Vertx)vertx));
            }
            case CLUSTERED: {
                if (!vertx.isClustered()) {
                    return Optional.of(LocalSessionStore.create((Vertx)vertx));
                }
                return Optional.of(ClusteredSessionStore.create((Vertx)vertx));
            }
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static final class NoOpHandler
    implements PlatformHandler {
        NoOpHandler() {
        }

        public void handle(RoutingContext routingContext) {
            routingContext.next();
        }
    }
}

