/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.helper;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.List;

public final class AsyncHelper {
    private AsyncHelper() {
    }

    public static CompositeFuture allComposite(List<? extends Future<?>> futures) {
        return CompositeFuture.all(futures);
    }

    public static CompositeFuture joinComposite(List<? extends Future<?>> futures) {
        return CompositeFuture.join(futures);
    }

    public static Future<Void> executeBlocking(Vertx vertx, ThrowingRunnable<Exception> asyncTask) {
        return vertx.executeBlocking(promise -> {
            try {
                asyncTask.run();
                promise.complete();
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
        });
    }

    public static <T> Future<T> executeBlocking(Vertx vertx, ThrowingSupplier<T, Exception> blockingSupplier) {
        return AsyncHelper.executeBlocking(vertx, (Promise<T> promise) -> {
            try {
                promise.complete(blockingSupplier.get());
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
        });
    }

    public static <T> Future<T> executeBlocking(Vertx vertx, ThrowingConsumer<Promise<T>, Exception> asyncTask) {
        Promise asyncTaskPromise = Promise.promise();
        vertx.executeBlocking(promise -> {
            try {
                asyncTask.accept((Promise)promise);
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
        }, (Handler)asyncTaskPromise);
        return asyncTaskPromise.future();
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T, E extends Exception> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

