/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.helper;

import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.io.InputStream;

public final class BufferHelper {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private BufferHelper() {
    }

    public static Buffer inputStreamToBuffer(InputStream input) throws IOException {
        return BufferHelper.inputStreamToBuffer(input, 4096);
    }

    public static Buffer inputStreamToBuffer(InputStream input, int bufferSize) throws IOException {
        int read;
        byte[] data = new byte[bufferSize];
        Buffer buffer = Buffer.buffer();
        while ((read = input.read(data, 0, data.length)) != -1) {
            buffer.appendBytes(data, 0, read);
        }
        return buffer;
    }

    public static class BufferInputStream
    extends InputStream {
        private Buffer buffer;
        private int position;

        public BufferInputStream(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int available() {
            return this.buffer.length() - this.position;
        }

        @Override
        public int read() {
            if (this.position == this.buffer.length()) {
                return -1;
            }
            return this.buffer.getByte(this.position++) & 0xFF;
        }

        @Override
        public int read(byte[] data, int offset, int length) {
            int size = Math.min(data.length, this.buffer.length() - this.position);
            if (size == 0) {
                return -1;
            }
            this.buffer.getBytes(this.position, this.position + size, data, offset);
            this.position += size;
            return size;
        }

        @Override
        public void close() {
            this.buffer = null;
        }
    }
}

