/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.helper;

import com.google.common.collect.BiMap;
import com.google.common.collect.Sets;
import io.neonbee.NeonBee;
import io.neonbee.internal.helper.CollectionHelper;
import io.neonbee.internal.helper.FileSystemHelper;
import io.neonbee.internal.helper.FunctionalHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class ConfigHelper {
    private ConfigHelper() {
    }

    public static Future<JsonObject> readConfig(Vertx vertx, String identifier) {
        Path configDirPath = NeonBee.get(vertx).getOptions().getConfigDirectory();
        return ConfigHelper.readConfig(vertx, identifier, configDirPath);
    }

    public static Future<JsonObject> readConfig(Vertx vertx, String identifier, Path configDirPath) {
        return FileSystemHelper.readYAML(vertx, configDirPath.resolve(identifier + ".yaml")).recover(ConfigHelper.notFound(() -> FileSystemHelper.readYAML(vertx, configDirPath.resolve(identifier + ".yml")))).recover(ConfigHelper.notFound(() -> FileSystemHelper.readJSON(vertx, configDirPath.resolve(identifier + ".json"))));
    }

    public static Future<JsonObject> readConfig(Vertx vertx, String identifier, JsonObject fallback) {
        return ConfigHelper.readConfig(vertx, identifier).recover(ConfigHelper.notFound(() -> Future.succeededFuture((Object)fallback)));
    }

    public static <T> Function<Throwable, Future<T>> notFound(Supplier<Future<T>> whenNotFound) {
        return throwable -> throwable.getCause() instanceof NoSuchFileException ? (Future)whenNotFound.get() : Future.failedFuture((Throwable)throwable);
    }

    public static JsonObject rephraseConfigNames(JsonObject config, BiMap<String, String> map, boolean inverse) {
        (!inverse ? map : map.inverse()).entrySet().forEach(FunctionalHelper.entryConsumer((fromName, toName) -> config.put(toName, config.remove(fromName))));
        return config;
    }

    public static JsonObject collectAdditionalConfig(JsonObject config, String ... notAdditional) {
        HashSet notAdditionalSet = Sets.newHashSet((Object[])notAdditional);
        notAdditionalSet.add("additionalConfig");
        return new JsonObject(config.stream().filter(FunctionalHelper.valuePredicate(Objects::nonNull)).filter(FunctionalHelper.keyPredicate(Predicate.not(notAdditionalSet::contains))).collect(CollectionHelper.identityMapCollector()));
    }
}

