/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class FileSystemHelper {
    private static final ObjectMapper YAML_MAPPER = new YAMLMapper();

    private FileSystemHelper() {
    }

    public static Future<Boolean> isDirectory(Vertx vertx, Path path) {
        return FileSystemHelper.getProperties(vertx, path).compose(properties -> Future.succeededFuture((Object)properties.isDirectory()));
    }

    public static Future<List<Path>> readDir(Vertx vertx, Path path) {
        return vertx.fileSystem().readDir(path.toString()).map(files -> files.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList()));
    }

    public static Future<List<Path>> readDir(Vertx vertx, Path path, String filter) {
        return vertx.fileSystem().readDir(path.toString(), filter).map(files -> files.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList()));
    }

    public static Future<AsyncFile> openFile(Vertx vertx, OpenOptions options, Path path) {
        return vertx.fileSystem().open(path.toString(), options);
    }

    public static Future<Buffer> readFile(Vertx vertx, Path path) {
        return vertx.fileSystem().readFile(path.toString());
    }

    public static Future<JsonObject> readJSON(Vertx vertx, Path path) {
        return FileSystemHelper.readFile(vertx, path).map(Buffer::toJsonObject);
    }

    public static Future<JsonObject> readYAML(Vertx vertx, Path path) {
        return FileSystemHelper.readFile(vertx, path).compose(buffer -> FileSystemHelper.parseYAML(vertx, buffer));
    }

    private static Future<JsonObject> parseYAML(Vertx vertx, Buffer buffer) {
        return vertx.executeBlocking(promise -> {
            try {
                JsonNode node = YAML_MAPPER.readTree(buffer.getBytes());
                promise.complete((Object)new JsonObject(node.toString()));
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
        });
    }

    public static Future<Void> writeFile(Vertx vertx, Path path, Buffer buffer) {
        return vertx.fileSystem().writeFile(path.toString(), buffer);
    }

    public static Future<Void> deleteRecursive(Vertx vertx, Path path) {
        return vertx.fileSystem().deleteRecursive(path.toString(), true);
    }

    public static Future<Boolean> exists(Vertx vertx, Path path) {
        return vertx.fileSystem().exists(path.toString());
    }

    public static Future<Void> createDirs(Vertx vertx, Path path) {
        return vertx.fileSystem().mkdirs(path.toString());
    }

    public static Future<FileProps> getProperties(Vertx vertx, Path path) {
        return vertx.fileSystem().props(path.toString());
    }

    public static Collection<Path> parsePaths(String ... paths) {
        return Arrays.stream(paths).flatMap(Pattern.compile(File.pathSeparator)::splitAsStream).map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList());
    }

    public static <V> V getPathFromMap(Map<String, V> map, String path) {
        return map.containsKey(path) ? map.get(path) : map.get(path.replace(File.separatorChar, File.separatorChar == '/' ? (char)'\\' : '/'));
    }
}

