/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.helper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class HostHelper {
    @VisibleForTesting
    static final String CF_INSTANCE_INTERNAL_IP_ENV_KEY = "CF_INSTANCE_INTERNAL_IP";
    private static String currentIp;

    private HostHelper() {
    }

    public static String getHostIp() {
        if (currentIp == null) {
            String ip = System.getenv(CF_INSTANCE_INTERNAL_IP_ENV_KEY);
            if (Strings.isNullOrEmpty((String)ip)) {
                try {
                    ip = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    ip = "127.0.0.1";
                }
            }
            currentIp = ip;
        }
        return currentIp;
    }
}

