/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.json;

import io.neonbee.internal.json.ImmutableJsonArray;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.Map;

public final class ImmutableJsonObject
extends JsonObject {
    public static final ImmutableJsonObject EMPTY = new ImmutableJsonObject();
    private final JsonObject object;

    public ImmutableJsonObject() {
        this(Collections.emptyMap());
    }

    public ImmutableJsonObject(String json) {
        this(new JsonObject(json));
    }

    public ImmutableJsonObject(Map<String, Object> map) {
        this(new JsonObject(map));
    }

    public ImmutableJsonObject(Buffer buf) {
        this(new JsonObject(buf));
    }

    public ImmutableJsonObject(JsonObject obj) {
        super(Collections.unmodifiableMap(obj.getMap()));
        this.object = obj instanceof ImmutableJsonObject ? ((ImmutableJsonObject)obj).object : obj;
    }

    public ImmutableJsonObject getJsonObject(String key) {
        JsonObject object = super.getJsonObject(key);
        return object != null ? new ImmutableJsonObject(object) : null;
    }

    public ImmutableJsonObject getJsonObject(String key, JsonObject def) {
        JsonObject object = super.getJsonObject(key, def);
        return object != null ? new ImmutableJsonObject(object) : null;
    }

    public ImmutableJsonArray getJsonArray(String key) {
        JsonArray array = super.getJsonArray(key);
        return array != null ? new ImmutableJsonArray(array) : null;
    }

    public ImmutableJsonArray getJsonArray(String key, JsonArray def) {
        JsonArray array = super.getJsonArray(key, def);
        return array != null ? new ImmutableJsonArray(array) : null;
    }

    public Object getValue(String key) {
        Object val = super.getValue(key);
        if (val instanceof JsonObject) {
            val = new ImmutableJsonObject((JsonObject)val);
        } else if (val instanceof JsonArray) {
            val = new ImmutableJsonArray((JsonArray)val);
        }
        return val;
    }

    public Object getValue(String key, Object def) {
        Object val = super.getValue(key, def);
        if (val instanceof JsonObject) {
            val = new ImmutableJsonObject((JsonObject)val);
        } else if (val instanceof JsonArray) {
            val = new ImmutableJsonArray((JsonArray)val);
        }
        return val;
    }

    public ImmutableJsonObject copy() {
        return this;
    }

    public boolean equals(Object other) {
        return this.object.equals(other instanceof ImmutableJsonObject ? ((ImmutableJsonObject)((Object)other)).object : other);
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public JsonObject mutableCopy() {
        return new JsonObject(this.getMap()).copy();
    }
}

