/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.scanner;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

class AnnotationClassVisitor
extends ClassVisitor {
    private final Set<String> classNames = new HashSet<String>();
    private final String annotationClassDescriptor;
    private final boolean includeTypes;
    private MethodVisitor methodVisitor;
    private FieldVisitor fieldVisitor;
    private String className;
    private int access;

    AnnotationClassVisitor(Class<? extends Annotation> annotation, ElementType ... elementTypes) {
        super(458752);
        this.annotationClassDescriptor = "L" + annotation.getName().replace('.', '/') + ";";
        HashSet<ElementType> elementTypeSet = new HashSet<ElementType>(Arrays.asList(elementTypes));
        this.includeTypes = elementTypeSet.contains((Object)ElementType.TYPE);
        if (elementTypeSet.contains((Object)ElementType.FIELD)) {
            this.fieldVisitor = new AnnotationFieldVisitor();
        }
        if (elementTypeSet.contains((Object)ElementType.METHOD)) {
            this.methodVisitor = new AnnotationMethodVisitor();
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name.replace('/', '.');
        this.access = access;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        return this.fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return this.methodVisitor;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.includeTypes && (this.access & 1) != 0 && this.annotationClassDescriptor.equals(desc)) {
            this.classNames.add(this.className);
        }
        return null;
    }

    public Set<String> getClassNames() {
        return Collections.unmodifiableSet(this.classNames);
    }

    class AnnotationFieldVisitor
    extends FieldVisitor {
        AnnotationFieldVisitor() {
            super(458752);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (visible && AnnotationClassVisitor.this.annotationClassDescriptor.equals(desc)) {
                AnnotationClassVisitor.this.classNames.add(AnnotationClassVisitor.this.className);
            }
            return null;
        }
    }

    class AnnotationMethodVisitor
    extends MethodVisitor {
        AnnotationMethodVisitor() {
            super(458752);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (visible && AnnotationClassVisitor.this.annotationClassDescriptor.equals(desc)) {
                AnnotationClassVisitor.this.classNames.add(AnnotationClassVisitor.this.className);
            }
            return null;
        }
    }
}

