/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.scanner;

import com.google.common.collect.Streams;
import io.neonbee.NeonBeeDeployable;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.helper.ThreadHelper;
import io.neonbee.internal.scanner.ClassPathScanner;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeployableScanner {
    private static final LoggingFacade LOGGER = LoggingFacade.create();

    public static Future<List<Class<? extends Verticle>>> scanForDeployableClasses(Vertx vertx) {
        return DeployableScanner.scanForDeployableClasses(vertx, ThreadHelper.getClassLoader());
    }

    private static Future<List<Class<? extends Verticle>>> scanForDeployableClasses(Vertx vertx, ClassLoader classLoader) {
        ClassPathScanner scanner = new ClassPathScanner();
        Future<List<String>> deployablesFromClassPath = scanner.scanForAnnotation(vertx, NeonBeeDeployable.class);
        Future<List<String>> deployablesFromManifest = scanner.scanManifestFiles(vertx, "NeonBee-Deployables");
        return CompositeFuture.all(deployablesFromClassPath, deployablesFromManifest).compose(compositeResult -> AsyncHelper.executeBlocking(vertx, () -> {
            List deployableFQNs = Streams.concat((Stream[])new Stream[]{((List)deployablesFromClassPath.result()).stream(), ((List)deployablesFromManifest.result()).stream()}).distinct().collect(Collectors.toList());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Found Deployables {}.", deployableFQNs.stream().collect(Collectors.joining(",")));
            }
            return deployableFQNs.stream().map(className -> {
                try {
                    return classLoader.loadClass((String)className).asSubclass(Verticle.class);
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("Deployables must subclass " + Verticle.class.getName(), e);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList());
        }));
    }
}

