/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.scanner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import io.neonbee.hook.Hook;
import io.neonbee.hook.Hooks;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.helper.ThreadHelper;
import io.neonbee.internal.scanner.ClassPathScanner;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HookScanner {
    @VisibleForTesting
    public static final String NEONBEE_HOOKS = "NeonBee-Hooks";
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private final ClassLoader classLoader;

    public HookScanner() {
        this(ThreadHelper.getClassLoader());
    }

    @VisibleForTesting
    HookScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Future<Set<Class<?>>> scanForHooks(Vertx vertx) {
        return this.scanForClassesContainingHooks(vertx).otherwise(throwable -> {
            LOGGER.warn("An error has occurred when trying to scan for hook.", (Throwable)throwable);
            return Set.of();
        });
    }

    @VisibleForTesting
    Future<Set<Class<?>>> scanForClassesContainingHooks(Vertx vertx) {
        ClassPathScanner scanner = new ClassPathScanner(this.classLoader);
        Future<List<String>> hookClassesWithAnnotations = scanner.scanForAnnotation(vertx, List.of(Hook.class, Hooks.class), ElementType.METHOD);
        Future hooksFromManifest = scanner.scanManifestFiles(vertx, NEONBEE_HOOKS).map(names -> names.stream().map(name -> name + ".class").collect(Collectors.toList()));
        return CompositeFuture.all(hookClassesWithAnnotations, (Future)hooksFromManifest).compose(compositeResult -> AsyncHelper.executeBlocking(vertx, () -> {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Annotated hook classes on class path {}.", String.join((CharSequence)",", (Iterable)hookClassesWithAnnotations.result()));
                LOGGER.info("Hook classes from manifest files on class path {}.", String.join((CharSequence)", ", (Iterable)hooksFromManifest.result()));
            }
            return Streams.concat((Stream[])new Stream[]{((List)hookClassesWithAnnotations.result()).stream(), ((List)hooksFromManifest.result()).stream()}).filter(Objects::nonNull).distinct().map(className -> {
                try {
                    return this.classLoader.loadClass((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toSet());
        }));
    }
}

