/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import com.google.common.base.Strings;
import io.neonbee.NeonBeeDeployable;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataMap;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataVerticle;
import io.neonbee.internal.verticle.LoggerConfiguration;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@NeonBeeDeployable(namespace="neonbee", autoDeploy=false)
public class LoggerManagerVerticle
extends DataVerticle<JsonArray> {
    public static final String QUERY_PARAMETER_LOGGERS = "loggers";
    public static final String QUERY_PARAMETER_LOCAL = "local";
    private static final String NAME = "LogLevel";
    public static final String QUALIFIED_NAME = DataVerticle.createQualifiedName("neonbee", "LogLevel");
    private static final String EVENT_BUS_CHANGE_LOG_LEVEL_ADDRESS = LoggerManagerVerticle.class.getSimpleName() + "ChangeLogLevel";
    private static final String PARAMETER_DELIMITERS = "[,; ]";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void start(Promise<Void> promise) {
        Promise superPromise = Promise.promise();
        super.start((Promise<Void>)superPromise);
        superPromise.future().compose(nothing -> {
            this.vertx.eventBus().consumer(EVENT_BUS_CHANGE_LOG_LEVEL_ADDRESS, message -> ((JsonArray)message.body()).stream().map(JsonObject.class::cast).map(LoggerConfiguration::fromJson).forEach(LoggerConfiguration::applyConfiguredLevel));
            return Future.succeededFuture();
        }).mapEmpty().onComplete(promise);
    }

    @Override
    public Future<JsonArray> retrieveData(DataQuery query, DataMap require, DataContext context) {
        Stream<Object> loggerConfigurationStream;
        String loggersParameter = query.getParameter(QUERY_PARAMETER_LOGGERS);
        if (!Strings.isNullOrEmpty((String)loggersParameter)) {
            String[] loggers = loggersParameter.split(PARAMETER_DELIMITERS);
            loggerConfigurationStream = Arrays.stream(loggers).map(LoggerConfiguration::getLoggerConfiguration);
        } else {
            loggerConfigurationStream = LoggerConfiguration.getLoggerConfigurations().stream();
        }
        return Future.succeededFuture((Object)new JsonArray(loggerConfigurationStream.map(LoggerConfiguration::toJson).collect(Collectors.toList())));
    }

    @Override
    public Future<JsonArray> updateData(DataQuery query, DataContext context) {
        this.vertx.eventBus().publish(EVENT_BUS_CHANGE_LOG_LEVEL_ADDRESS, (Object)Optional.ofNullable(query.getBody()).map(Buffer::toJsonArray).orElse(new JsonArray()), new DeliveryOptions().setLocalOnly(Boolean.toString(true).equals(query.getParameter(QUERY_PARAMETER_LOCAL))));
        return Future.succeededFuture();
    }
}

