/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import io.neonbee.NeonBee;
import io.neonbee.internal.verticle.WatchVerticle;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.Promise;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;

public class ModelRefreshVerticle
extends WatchVerticle {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final int DEFAULT_CHECK_INTERVAL = 5;

    public ModelRefreshVerticle(Path modelsDirPath) {
        super(modelsDirPath, 5L, TimeUnit.SECONDS, false, false);
    }

    ModelRefreshVerticle(Path modelsDirPath, long interval, TimeUnit unit) {
        super(modelsDirPath, interval, unit, false, false);
    }

    @Override
    public void observedCreate(Path affectedPath, Promise<Void> finishPromise) {
        if (!ModelRefreshVerticle.isCopyLogic(this.config())) {
            this.triggerRefresh(finishPromise);
        } else {
            finishPromise.complete();
        }
    }

    @Override
    public void observedModify(Path affectedPath, Promise<Void> finishPromise) {
        if (ModelRefreshVerticle.isCopyLogic(this.config())) {
            this.triggerRefresh(finishPromise);
        } else {
            finishPromise.complete();
        }
    }

    @Override
    public void observedDelete(Path affectedPath, Promise<Void> finishPromise) {
        this.triggerRefresh(finishPromise);
    }

    private void triggerRefresh(Promise<Void> finishPromise) {
        NeonBee.get(this.vertx).getModelManager().reloadModels().map((Object)null).onComplete(asyncResult -> {
            LOGGER.debug("Models have been refreshed.");
            finishPromise.handle(asyncResult);
        });
    }
}

