/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.job;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;

public class JobSchedule
implements TemporalAdjuster {
    private Instant start;
    private Instant end;
    private TemporalAdjuster adjuster;

    public JobSchedule() {
        this((Instant)null);
    }

    public JobSchedule(Instant start) {
        this(start, (TemporalAdjuster)null);
    }

    public JobSchedule(Duration interval) {
        this(null, interval);
    }

    public JobSchedule(Duration interval, Instant end) {
        this(null, interval, end);
    }

    public JobSchedule(Instant start, Duration interval) {
        this(start, interval, null);
    }

    public JobSchedule(Instant start, Duration interval, Instant end) {
        this(start, (Temporal temporal) -> temporal.plus(interval), end);
    }

    public JobSchedule(TemporalAdjuster adjuster) {
        this(null, adjuster);
    }

    public JobSchedule(TemporalAdjuster adjuster, Instant end) {
        this(null, adjuster, end);
    }

    public JobSchedule(Instant start, TemporalAdjuster adjuster) {
        this(start, adjuster, null);
    }

    public JobSchedule(Instant start, TemporalAdjuster adjuster, Instant end) {
        this.start = start;
        this.adjuster = adjuster;
        this.end = end;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public boolean isPeriodic() {
        return this.adjuster != null;
    }

    public TemporalAdjuster getAdjuster() {
        return this.adjuster;
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return this.adjuster.adjustInto(temporal);
    }
}

