/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.job;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.data.DataContext;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.job.JobSchedule;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;

public abstract class JobVerticle
extends AbstractVerticle {
    @VisibleForTesting
    static final long MINIMUM_DELAY = 100L;
    @VisibleForTesting
    static final long FINALIZE_DELAY = 50L;
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final long NO_SCHEDULE = -1L;
    private static final long STOPPED = -2L;
    private static final long FINALIZED = -3L;
    private static final int SCHEDULE_TEST_EXECUTIONS = 10;
    private JobSchedule schedule;
    private Instant lastExecution;
    private boolean undeployWhenDone;
    private long currentTimerId = -1L;

    public JobVerticle(JobSchedule schedule) {
        this(schedule, true);
    }

    public JobVerticle(JobSchedule schedule, boolean undeployWhenDone) {
        this.schedule = schedule;
        this.undeployWhenDone = undeployWhenDone;
    }

    public JobSchedule getSchedule() {
        return this.schedule;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (!NeonBee.get(this.getVertx()).getOptions().shouldDisableJobScheduling()) {
            if (!this.isScheduleValid()) throw new IllegalStateException("The period of a periodic JobSchedule can't be zero");
            this.scheduleJob();
            return;
        } else {
            this.finalizeJob();
        }
    }

    public void stop() {
        if (this.currentTimerId >= 0L) {
            this.getVertx().cancelTimer(this.currentTimerId);
            this.currentTimerId = -2L;
        }
    }

    private boolean isScheduleValid() {
        if (this.schedule.isPeriodic()) {
            Instant before = Instant.now();
            for (int x = 0; x < 10; ++x) {
                Instant after = before.with(this.schedule);
                if (after.compareTo(before) > 0) continue;
                return false;
            }
        }
        return true;
    }

    private void scheduleJob() {
        Instant nextExecution;
        boolean periodicSchedule = this.schedule.isPeriodic();
        Instant now = Instant.now();
        Instant scheduledStart = this.schedule.getStart();
        Instant scheduledEnd = this.schedule.getEnd();
        if (scheduledStart != null && !periodicSchedule && scheduledStart.isBefore(now) || scheduledEnd != null && scheduledEnd.isBefore(now)) {
            this.finalizeJob();
            return;
        }
        Instant instant = this.lastExecution != null ? this.lastExecution : (nextExecution = scheduledStart != null ? scheduledStart : now);
        while (nextExecution.isBefore(now)) {
            nextExecution = periodicSchedule ? nextExecution.with(this.schedule) : now;
        }
        if (scheduledEnd != null && nextExecution.isAfter(scheduledEnd)) {
            this.finalizeJob();
            return;
        }
        this.lastExecution = nextExecution;
        long nextDelay = Math.max(100L, now.until(this.lastExecution, ChronoUnit.MILLIS));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Scheduling job execution of {} in {}ms ({})", new Object[]{this.getName(), nextDelay, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC).plus(nextDelay, ChronoUnit.MILLIS))});
        }
        this.currentTimerId = this.getVertx().setTimer(nextDelay, timerID -> {
            DataContextImpl context = new DataContextImpl(UUID.randomUUID().toString(), "internal-" + UUID.randomUUID().toString(), this.getUser());
            LOGGER.correlateWith(context).info("Job execution of {} started", ((Object)((Object)this)).getClass().getSimpleName());
            Optional.ofNullable(this.execute(context)).orElse(Future.succeededFuture()).onComplete(result -> {
                if (result.succeeded()) {
                    LOGGER.correlateWith(context).info("Job execution of {} ended successfully", this.getName());
                } else {
                    LOGGER.correlateWith(context).warn("Job execution of {} ended with failure", this.getName(), result.cause());
                }
                if (periodicSchedule) {
                    this.scheduleJob();
                } else {
                    this.finalizeJob();
                }
            });
        });
    }

    protected void finalizeJob() {
        String name = this.getName();
        LOGGER.info("Finalizing job {}", name);
        this.currentTimerId = -3L;
        if (this.undeployWhenDone) {
            this.getVertx().setTimer(50L, timerId -> {
                LOGGER.info("Undeploying job {}, as processing finished", name);
                this.getVertx().undeploy(this.deploymentID()).onFailure(throwable -> LOGGER.error("Failed to undeploy job {}", name, throwable));
            });
        }
    }

    public boolean isFinalized() {
        return this.currentTimerId == -3L;
    }

    public abstract Future<?> execute(DataContext var1);

    protected JsonObject getUser() {
        return new JsonObject().put("user_name", (Object)String.format("job_%s", ((Object)((Object)this)).getClass().getSimpleName()));
    }
}

