/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.logging;

import io.neonbee.data.DataContext;
import io.neonbee.internal.helper.ThreadHelper;
import io.neonbee.logging.internal.LoggingFacadeImpl;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LoggingFacade
extends Logger {
    public static LoggingFacade masqueradeLogger(Logger logger) {
        return new LoggingFacadeImpl(logger);
    }

    public static LoggingFacade create(String name) {
        return LoggingFacade.masqueradeLogger(LoggerFactory.getLogger((String)name));
    }

    public static LoggingFacade create(Class<?> clazz) {
        return LoggingFacade.masqueradeLogger(LoggerFactory.getLogger(clazz));
    }

    public static LoggingFacade create() {
        return LoggingFacade.create(ThreadHelper.getCallingClass());
    }

    public LoggingFacade correlateWith(String var1);

    default public LoggingFacade correlateWith(RoutingContext routingContext) {
        if (routingContext == null) {
            String msg = "routingContext must not be null, otherwise no correlationId can be extracted";
            throw new NullPointerException(msg);
        }
        Optional.ofNullable(routingContext.get("correlationId")).map(Object::toString).ifPresent(this::correlateWith);
        return this;
    }

    default public LoggingFacade correlateWith(DataContext context) {
        return this.correlateWith(context.correlationId());
    }
}

