/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.logging.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.neonbee.logging.LoggingFacade;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LoggingFacadeImpl
implements LoggingFacade {
    @VisibleForTesting
    static final Marker DEFAULT_MARKER = MarkerFactory.getDetachedMarker((String)"noCorrelationIdAvailable");
    @VisibleForTesting
    static final UnsupportedOperationException UNSUPPORTED_OPERATION_EXCEPTION = new UnsupportedOperationException("Using masqueraded log messages on this facade supplying an own marker is not supported");
    private final Logger logger;
    @VisibleForTesting
    Marker currentMarker = DEFAULT_MARKER;

    public LoggingFacadeImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public LoggingFacade correlateWith(String correlationId) {
        if (Strings.isNullOrEmpty((String)correlationId)) {
            this.currentMarker = DEFAULT_MARKER;
        } else if (this.currentMarker == null || !correlationId.equals(this.currentMarker.getName())) {
            this.currentMarker = MarkerFactory.getDetachedMarker((String)correlationId);
        }
        return this;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled(this.currentMarker);
    }

    public boolean isTraceEnabled(Marker marker) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void trace(String msg) {
        this.logger.trace(this.currentMarker, msg);
    }

    public void trace(String format, Object arg) {
        this.logger.trace(this.currentMarker, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logger.trace(this.currentMarker, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.logger.trace(this.currentMarker, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.logger.trace(this.currentMarker, msg, t);
    }

    public void trace(Marker marker, String msg) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void trace(Marker marker, String format, Object arg) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void trace(Marker marker, String msg, Throwable t) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled(this.currentMarker);
    }

    public boolean isDebugEnabled(Marker marker) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void debug(String msg) {
        this.logger.debug(this.currentMarker, msg);
    }

    public void debug(String format, Object arg) {
        this.logger.debug(this.currentMarker, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logger.debug(this.currentMarker, format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.logger.debug(this.currentMarker, format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.logger.debug(this.currentMarker, msg, t);
    }

    public void debug(Marker marker, String msg) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void debug(Marker marker, String format, Object arg) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void debug(Marker marker, String msg, Throwable t) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled(this.currentMarker);
    }

    public boolean isInfoEnabled(Marker marker) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void info(String msg) {
        this.logger.info(this.currentMarker, msg);
    }

    public void info(String format, Object arg) {
        this.logger.info(this.currentMarker, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logger.info(this.currentMarker, format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.logger.info(this.currentMarker, format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.logger.info(this.currentMarker, msg, t);
    }

    public void info(Marker marker, String msg) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void info(Marker marker, String format, Object arg) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void info(Marker marker, String format, Object ... arguments) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void info(Marker marker, String msg, Throwable t) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled(this.currentMarker);
    }

    public boolean isWarnEnabled(Marker marker) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void warn(String msg) {
        this.logger.warn(this.currentMarker, msg);
    }

    public void warn(String format, Object arg) {
        this.logger.warn(this.currentMarker, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logger.warn(this.currentMarker, format, arg1, arg2);
    }

    public void warn(String format, Object ... arguments) {
        this.logger.warn(this.currentMarker, format, arguments);
    }

    public void warn(String msg, Throwable t) {
        this.logger.warn(this.currentMarker, msg, t);
    }

    public void warn(Marker marker, String msg) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void warn(Marker marker, String format, Object arg) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void warn(Marker marker, String msg, Throwable t) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled(this.currentMarker);
    }

    public boolean isErrorEnabled(Marker marker) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void error(String msg) {
        this.logger.error(this.currentMarker, msg);
    }

    public void error(String format, Object arg) {
        this.logger.error(this.currentMarker, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logger.error(this.currentMarker, format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.logger.error(this.currentMarker, format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.logger.error(this.currentMarker, msg, t);
    }

    public void error(Marker marker, String msg) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void error(Marker marker, String format, Object arg) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void error(Marker marker, String format, Object ... arguments) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    public void error(Marker marker, String msg, Throwable t) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }
}

