/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.RegularExpressions;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import java.net.IDN;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class BaseFormatValidatorFactory
implements ValidatorFactory {
    protected static final Predicate<String> URI_VALIDATOR = in -> {
        try {
            return URI.create(in).isAbsolute();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    };
    protected static final Predicate<String> URI_REFERENCE_VALIDATOR = in -> {
        try {
            URI.create(in);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    };
    protected static final Predicate<String> REGEX_VALIDATOR = in -> {
        try {
            Pattern.compile(in);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    };
    protected static final Predicate<String> IDN_HOSTNAME_VALIDATOR = in -> {
        try {
            IDN.toASCII(in);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    };
    protected static final Predicate<String> IDN_EMAIL_VALIDATOR = in -> {
        try {
            int atIndex = in.indexOf(64);
            if (atIndex < 0) {
                return false;
            }
            String localPart = in.substring(0, atIndex);
            if (!RegularExpressions.EMAIL_LOCAL.matcher(localPart).matches()) {
                return false;
            }
            IDN.toASCII(in.substring(atIndex + 1));
            return true;
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException e) {
            return false;
        }
    };
    protected static final Predicate<String> UUID_VALIDATOR = in -> {
        try {
            UUID.fromString(in);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    };
    protected final Map<String, Predicate<String>> formats = this.initFormatsMap();
    protected final List<String> ignoringFormats = this.initIgnoringFormats();

    protected List<String> initIgnoringFormats() {
        return Arrays.asList("int32", "int64", "float", "double");
    }

    public abstract Map<String, Predicate<String>> initFormatsMap();

    public void addStringFormatValidator(String formatName, Predicate<String> validator) {
        this.formats.put(formatName, validator);
    }

    protected Predicate<String> createPredicateFromPattern(Pattern pattern) {
        return in -> pattern.matcher((CharSequence)in).matches();
    }

    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        String format = schema.getString("format");
        if (this.ignoringFormats.contains(format)) {
            return null;
        }
        Predicate<String> v = this.formats.get(format);
        if (v == null) {
            throw new SchemaException(schema, "Format not supported");
        }
        return new FormatValidator(v);
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("format");
    }

    static class FormatValidator
    extends BaseSyncValidator {
        final Predicate<String> validator;

        public FormatValidator(Predicate<String> validator) {
            this.validator = validator;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            if (in instanceof String && !this.validator.test((String)in)) {
                throw ValidationException.create("Provided value don't match pattern", "pattern", in);
            }
        }
    }
}

